package PqEdCozar;

/**
 * La clase Cafetera almacena la información de las máquinas de café.
 * <ul><li>De capsulas</li><li>Espreso</li><li>Moka</li><li>...</li><ul>
 * @author Damian
 * @author <h1>Sara</h1>
 * @version 2.1
 * @since 2.1
 */

//Damian
//Hola que pasa
//Bien
public class Cafetera {
    private int nivel;
    private String tipo;
    
    /**
     * Por Ejemplo:
     * <PRE>cafet1 = new Cafetera(1000, "torrefacto")</PRE>
     * @param pNivel recibe el nivel de café que contiene la cafetera.
     * @param pTipo recibe el tipo (torrefacto, mezcla, ...) de cafe presente en la cafetera.
     */
    public Cafetera(int pNivel, String pTipo){
        this.nivel=pNivel;
        this.tipo=pTipo;
    }
    
    /**
     * 
     * @return Devuelve el tipo ("torrefacto", 
     *       "mezcla, ...")
     * @see String
     * @see "Los devuelves"
     * @see <a href="http://docs.oracle.com/javase/7/docs/technotes/guides/javadoc/whatsnew-1.5.0.html">docs.oracle.com - Pagina oficial de java : Novedad en Javadoc</a>
     */
    public String devTipo(){
        return this.tipo;
    }
    
    /**
     * Asigna un <b>tipo</b> en la clase Cafetera.
     * @param pTipo El nuevo tipo de la cafetera.
     * @throws IllegalArgumentException Si tipo es null, esta vacio o contiene solo espacios.
     */
    public void asignaTipo(String pTipo){
        if ((pTipo == null)||(pTipo.trim().isEmpty())) {
            throw new IllegalArgumentException("El tipo no puede ser nulo o vacio.");
        } else{
            this.tipo=pTipo;
        }
        this.tipo=pTipo;
    }
    
    /**
     *
     * @param pCadena
     * @return
     */
    public String devCadMejorada(String pCadena){
        String rdo;
        rdo=pCadena;
        
        rdo=pCadena.trim();
        
        return rdo;
    }
}
