package com.example.pruebassicloud;

import org.andengine.engine.camera.Camera;
import org.andengine.engine.options.EngineOptions;
import org.andengine.engine.options.ScreenOrientation;
import org.andengine.engine.options.resolutionpolicy.RatioResolutionPolicy;
import org.andengine.entity.scene.IOnSceneTouchListener;
import org.andengine.entity.scene.Scene;
import org.andengine.entity.scene.background.Background;
import org.andengine.entity.sprite.ButtonSprite;
import org.andengine.entity.sprite.ButtonSprite.OnClickListener;
import org.andengine.entity.text.Text;
import org.andengine.entity.text.TextOptions;
import org.andengine.entity.util.FPSLogger;
import org.andengine.input.touch.TouchEvent;
import org.andengine.opengl.font.Font;
import org.andengine.opengl.font.FontFactory;
import org.andengine.opengl.texture.atlas.bitmap.BitmapTextureAtlas;
import org.andengine.opengl.texture.atlas.bitmap.BitmapTextureAtlasTextureRegionFactory;
import org.andengine.opengl.texture.region.ITextureRegion;
import org.andengine.opengl.vbo.VertexBufferObjectManager;
import org.andengine.ui.activity.SimpleBaseGameActivity;
import org.andengine.util.HorizontalAlign;
import android.app.AlertDialog;
import android.content.DialogInterface;
import android.content.Intent;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.graphics.Typeface;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;


public class Lista extends SimpleBaseGameActivity implements IOnSceneTouchListener{

	Camera camera;
	private static  int CAMERA_WIDTH;
	private static  int CAMERA_HEIGHT;
	
	//Boton
	private BitmapTextureAtlas mBitmapTextureAtlas;
	private ITextureRegion mBotonTextureRegion;
	
	//Letras
	private Font  mFont;
	private Font fuenteregistro;
	
	//Scroll
	private float  mTouchY = 0, mTouchOffsetY = 0;
	
	Cursor datos;
	AlertDialog.Builder builder;
	int id;

	@Override
	public EngineOptions onCreateEngineOptions() {
		//CREAR CAMARA
		DisplayMetrics metrics = new DisplayMetrics();
		getWindowManager().getDefaultDisplay().getMetrics(metrics);
		CAMERA_WIDTH = metrics.widthPixels;
		CAMERA_HEIGHT = metrics.heightPixels;
		
		 camera = new Camera(0, 0, CAMERA_WIDTH, CAMERA_HEIGHT);
		 return new EngineOptions(true, ScreenOrientation.LANDSCAPE_FIXED, new RatioResolutionPolicy(CAMERA_WIDTH, CAMERA_HEIGHT), camera);
}

	@Override
	protected void onCreateResources() {
		  BitmapTextureAtlasTextureRegionFactory.setAssetBasePath("gfx/");
		  
		  //BOTÓN
		  this.mBitmapTextureAtlas = new BitmapTextureAtlas(this.getTextureManager(), 100, 25);
		  mBotonTextureRegion = BitmapTextureAtlasTextureRegionFactory.createFromAsset(this.mBitmapTextureAtlas, this,
		      "editarregistro.png", 0, 0);
		  this.mBitmapTextureAtlas.load();
		  
		  //FUENTE
			this.mFont = FontFactory.create(this.getFontManager(), this.getTextureManager(), 256, 256, Typeface.create(Typeface.DEFAULT, Typeface.BOLD), 72, true, android.graphics.Color.RED);
			this.mFont.load();
			this.fuenteregistro = FontFactory.create(this.getFontManager(), this.getTextureManager(), 256, 256, Typeface.create(Typeface.DEFAULT, Typeface.BOLD), 25, true, android.graphics.Color.GREEN);
			this.fuenteregistro.load();
	}

	@Override
	protected Scene onCreateScene() {
		//MOSTRAR FPS POR CONSOLA
		this.mEngine.registerUpdateHandler(new FPSLogger());

		  final Scene scene = new Scene();
		  
		  scene.setBackground(new Background(1, 1, 1));
		  
		  //TITULO
		  
		  final VertexBufferObjectManager vertexBufferObjectManager = this.getVertexBufferObjectManager();
		  final Text titulo = new Text(0, 0, this.mFont, "Registros:", new TextOptions(HorizontalAlign.CENTER), vertexBufferObjectManager);
		  scene.attachChild(titulo);
		  titulo.setPosition(CAMERA_WIDTH / 2 - titulo.getWidth() / 2, 20);
		  
		  
		  TF_BBDD bde = new TF_BBDD(this);
		  SQLiteDatabase bd = bde.getReadableDatabase();
		  
		  datos = bd.rawQuery("SELECT * FROM TF_BBDD", null);
		  ButtonSprite [] btsa= new ButtonSprite[datos.getCount()];
		  datos.moveToFirst();
		  float posActual = titulo.getY() + titulo.getHeight() + 20;
		  for(int i=0; i<=datos.getCount()-1; i++)
		  {
			  final Text registro = new Text(0,0, this.fuenteregistro, datos.getString(1) +" - "+ datos.getString(2), new TextOptions(HorizontalAlign.CENTER), vertexBufferObjectManager);
			  registro.setPosition(CAMERA_WIDTH / 2 - registro.getWidth()/2, posActual + registro.getHeight() + 20);
			  scene.attachChild(registro);
			  btsa[i] = new ButtonSprite(0, 0, this.mBotonTextureRegion, this.getVertexBufferObjectManager());
			  btsa[i].setPosition((CAMERA_WIDTH / 4)*3, posActual + registro.getHeight() + 20);
			  btsa[i].setTag(i);
			  btsa[i].setOnClickListener(new OnClickListener() {
				
				@Override
				public void onClick(ButtonSprite pButtonSprite, float pTouchAreaLocalX,
						float pTouchAreaLocalY) {
					id = pButtonSprite.getTag();
					Lista.this.runOnUiThread(new Runnable() {
					       public void run() {
					  DialogRes(id); 
					       }
				});
				};
			});
			  
			  scene.attachChild(btsa[i]);
			  scene.registerTouchArea(btsa[i]);
			  posActual += 20 + registro.getHeight();
			  datos.moveToNext();
		  }		  
		  bd.close();
		  scene.setOnSceneTouchListener(this);
		  return scene;
}
	
private void DialogRes(final int resultado){
	builder = new AlertDialog.Builder(this);
	
datos.moveToPosition(resultado);		

builder.setTitle("¿Desea cambiar el registro?");
LinearLayout lila1= new LinearLayout(this);
lila1.setOrientation(1);//1 is for vertical orientation
final TextView texto1 = new TextView(this);
texto1.setText("Nombre: ");
final EditText input = new EditText(this); 
input.setText(datos.getString(1));
final TextView texto2 = new TextView(this);
texto2.setText("Descripción: ");
final EditText input1 = new EditText(this);
input1.setText(datos.getString(2));

lila1.addView(texto1);
lila1.addView(input);
lila1.addView(texto2);
lila1.addView(input1);
builder.setView(lila1);

final TF_BBDD bde = new TF_BBDD(this);

builder.setPositiveButton("Cambiar Registro", new DialogInterface.OnClickListener() {
	public void onClick(DialogInterface dialog, int whichButton) {
		
		  bde.ModificarRegistro(datos.getInt(0), input.getText().toString(), input1.getText().toString());
		  Toast.makeText(Lista.this, "Registro editado correctamente", Toast.LENGTH_LONG).show();
		  }
		});
builder.setNegativeButton("Cancelar", new DialogInterface.OnClickListener() {

	@Override
	public void onClick(DialogInterface dialog, int which) {
		
	}
	});
		AlertDialog ald = builder.show();
		ald.show();
		
		//ald.dismiss();
}

@Override
public void onBackPressed()
{
	volverInicio();	
}

private void volverInicio(){
	Intent inten = new Intent(this, Menu.class);
	startActivity(inten);
	this.finish();
}

@SuppressWarnings("static-access")
@Override
public boolean onSceneTouchEvent(Scene pScene, TouchEvent pSceneTouchEvent) {
	if(pSceneTouchEvent.getAction() == pSceneTouchEvent.ACTION_DOWN)
    {
           // mTouchX = pSceneTouchEvent.getMotionEvent().getX();
            mTouchY = pSceneTouchEvent.getMotionEvent().getY();
    }
    else if(pSceneTouchEvent.getAction() == MotionEvent.ACTION_MOVE)
    {
           // float newX = pSceneTouchEvent.getMotionEvent().getX();
            float newY = pSceneTouchEvent.getMotionEvent().getY();
           
            //mTouchOffsetX = (newX - mTouchX);
            mTouchOffsetY = (newY - mTouchY);
           
            //float newScrollX = this.camera.getCenterX() - mTouchOffsetX;
            float newScrollY = this.camera.getCenterY() - mTouchOffsetY;
           
            this.camera.setCenter(camera.getCenterX(), newScrollY);
           
           // mTouchX = newX;
            mTouchY = newY;
    }
    return true;
}

}


	