package com.example.pruebaslocales;

import org.andengine.engine.camera.Camera;
import org.andengine.engine.handler.timer.ITimerCallback;
import org.andengine.engine.handler.timer.TimerHandler;
import org.andengine.engine.options.EngineOptions;
import org.andengine.engine.options.ScreenOrientation;
import org.andengine.engine.options.resolutionpolicy.RatioResolutionPolicy;
import org.andengine.entity.scene.Scene;
import org.andengine.entity.scene.background.Background;
import org.andengine.entity.text.AutoWrap;
import org.andengine.entity.text.Text;
import org.andengine.entity.text.TextOptions;
import org.andengine.opengl.font.Font;
import org.andengine.opengl.font.FontFactory;
import org.andengine.opengl.vbo.VertexBufferObjectManager;
import org.andengine.ui.activity.SimpleLayoutGameActivity;
import org.andengine.util.HorizontalAlign;

import android.graphics.Typeface;
import android.graphics.drawable.ColorDrawable;
import android.util.DisplayMetrics;
import android.view.View;
import android.widget.AdapterView;
import android.widget.TextView;


public class MainActivity extends SimpleLayoutGameActivity{

	private static int CAMERA_WIDTH;
	private static int CAMERA_HEIGHT;
	private Font  mFont;
	Text titulo;
	private Text mText;

	TextView tv;

	@Override
	public EngineOptions onCreateEngineOptions() {
		DisplayMetrics metrics = new DisplayMetrics();
		getWindowManager().getDefaultDisplay().getMetrics(metrics);
		CAMERA_WIDTH = metrics.widthPixels;
		CAMERA_HEIGHT = metrics.heightPixels;
		
		Camera camera = new Camera(0, 0, CAMERA_WIDTH, CAMERA_HEIGHT);		
		
		
		 EngineOptions en = new EngineOptions(true, ScreenOrientation.PORTRAIT_SENSOR, new RatioResolutionPolicy(CAMERA_WIDTH, CAMERA_HEIGHT), camera);
		 
		return en;
	}

	@Override
	protected void onCreateResources() {
		this.mFont = FontFactory.create(this.getFontManager(), this.getTextureManager(), 256, 256, Typeface.create(Typeface.DEFAULT, Typeface.BOLD), 60, true, android.graphics.Color.GRAY);
		this.mFont.load();
		
	}

	@Override
	protected Scene onCreateScene() {
		final Scene scene = new Scene();
		scene.setBackground(new Background(1,1,1,1));
		
		final VertexBufferObjectManager vertexBufferObjectManager = this.getVertexBufferObjectManager();

		titulo = new Text(0, 0, this.mFont, "¡Letras aleatorias!", new TextOptions(HorizontalAlign.CENTER), vertexBufferObjectManager);
		  scene.attachChild(titulo);
		  titulo.setPosition(CAMERA_WIDTH / 2 - titulo.getWidth() / 2, 20);
		scene.registerUpdateHandler(new TimerHandler(0.5f, new ITimerCallback(){
			@Override public void onTimePassed(TimerHandler pTimerHandler) {
			runOnUiThread(new Runnable() {
			@Override public void run() {
				
			MainActivity.this.findViewById(
			R.id.xmllayoutexample_rendersurfaceview).setBackgroundDrawable(null);
			MainActivity.this.findViewById(R.id.label).setVisibility(View.VISIBLE);
			} }); scene.unregisterUpdateHandler(pTimerHandler);
			} }));
		
return scene;
			}

	@Override
	protected int getLayoutID() {
return R.layout.activity_main;
	}

	@Override
	protected int getRenderSurfaceViewID() {
return R.id.xmllayoutexample_rendersurfaceview;
	}
	
}
