package com.example.pruebassicloud;
 
import org.andengine.engine.camera.Camera;
import org.andengine.engine.options.EngineOptions;
import org.andengine.engine.options.ScreenOrientation;
import org.andengine.engine.options.resolutionpolicy.RatioResolutionPolicy;
import org.andengine.entity.scene.Scene;
import org.andengine.entity.scene.background.Background;
import org.andengine.entity.scene.menu.MenuScene;
import org.andengine.entity.scene.menu.MenuScene.IOnMenuItemClickListener;
import org.andengine.entity.scene.menu.item.IMenuItem;
import org.andengine.entity.scene.menu.item.SpriteMenuItem;
import org.andengine.entity.scene.menu.item.decorator.ScaleMenuItemDecorator;
import org.andengine.opengl.texture.TextureOptions;
import org.andengine.opengl.texture.atlas.bitmap.BitmapTextureAtlas;
import org.andengine.opengl.texture.atlas.bitmap.BitmapTextureAtlasTextureRegionFactory;
import org.andengine.opengl.texture.atlas.bitmap.BuildableBitmapTextureAtlas;
import org.andengine.opengl.texture.atlas.bitmap.source.IBitmapTextureAtlasSource;
import org.andengine.opengl.texture.atlas.buildable.builder.BlackPawnTextureAtlasBuilder;
import org.andengine.opengl.texture.atlas.buildable.builder.ITextureAtlasBuilder.TextureAtlasBuilderException;
import org.andengine.opengl.texture.region.ITextureRegion;
import org.andengine.ui.activity.SimpleBaseGameActivity;
import org.andengine.util.color.Color;
import android.content.Intent;
import android.util.DisplayMetrics;

public class Menu extends SimpleBaseGameActivity implements IOnMenuItemClickListener{

	
	//CONSTANTES
	private static int CAMERA_WIDTH;
	private static int CAMERA_HEIGHT;

	//VARIABLES
	private Camera	camera;
	private Scene mainScene;
	private MenuScene menuScene;
	
	private final int MENU_NUEVO = 0;
	private final int MENU_LISTA = 1;
	private final int MENU_RELOJ = 2;
	private final int MENU_ALEATORIO = 3;
	
	private BuildableBitmapTextureAtlas	menuBtnTexture;
	private ITextureRegion menuBtnNuevo;
	private ITextureRegion menuBtnLista;
	private ITextureRegion menuBtnReloj;
	private ITextureRegion menuBtnAleatorio;
	
	@Override
	public EngineOptions onCreateEngineOptions() {
		DisplayMetrics metrics = new DisplayMetrics();
		getWindowManager().getDefaultDisplay().getMetrics(metrics);
		CAMERA_WIDTH = metrics.widthPixels;
		CAMERA_HEIGHT = metrics.heightPixels;
		camera = new Camera(0, 0, CAMERA_WIDTH, CAMERA_HEIGHT);
		EngineOptions en = new EngineOptions(true, ScreenOrientation.LANDSCAPE_FIXED, new RatioResolutionPolicy(CAMERA_WIDTH,
				CAMERA_HEIGHT), camera);

		return en;
	}

	@Override
	protected void onCreateResources() {
		BitmapTextureAtlasTextureRegionFactory.setAssetBasePath("gfx/");
		menuBtnTexture = new BuildableBitmapTextureAtlas(getTextureManager(), 1024, 601,
				TextureOptions.BILINEAR_PREMULTIPLYALPHA);
		menuBtnNuevo = BitmapTextureAtlasTextureRegionFactory.createFromAsset(menuBtnTexture, getAssets(), "nuevo.png");
		menuBtnLista = BitmapTextureAtlasTextureRegionFactory.createFromAsset(menuBtnTexture, getAssets(), "lista.png");
		menuBtnReloj = BitmapTextureAtlasTextureRegionFactory.createFromAsset(menuBtnTexture, getAssets(), "reloj.png");
		menuBtnAleatorio = BitmapTextureAtlasTextureRegionFactory.createFromAsset(menuBtnTexture, getAssets(), "dado.png");
		try
		{
			menuBtnTexture.build(new BlackPawnTextureAtlasBuilder<IBitmapTextureAtlasSource, BitmapTextureAtlas>(0, 1, 0));
			menuBtnTexture.load();
		} catch (TextureAtlasBuilderException e)
		{

			
		
		}
	}
	
	@Override
	protected Scene onCreateScene() {
		mainScene = new Scene();
		mainScene.setBackground(new Background(Color.WHITE));
		menuScene = new MenuScene(camera);
		final IMenuItem nombreButton = new ScaleMenuItemDecorator(new SpriteMenuItem(MENU_NUEVO, 200, 70, menuBtnNuevo,
				getVertexBufferObjectManager()), 1.1f, 1);

		final IMenuItem descripcionButton = new ScaleMenuItemDecorator(new SpriteMenuItem(MENU_LISTA, 200, 70, menuBtnLista,
				getVertexBufferObjectManager()), 1.1f, 1);
		
		final IMenuItem relojButton = new ScaleMenuItemDecorator(new SpriteMenuItem(MENU_RELOJ, 150, 159, menuBtnReloj,
				getVertexBufferObjectManager()), 1.1f, 1);
		
		final IMenuItem relojAleatorio = new ScaleMenuItemDecorator(new SpriteMenuItem(MENU_ALEATORIO, 150, 97, menuBtnAleatorio,
				getVertexBufferObjectManager()), 1.1f, 1);
		
		nombreButton.setPosition(CAMERA_WIDTH / 2 - nombreButton.getWidth() / 2, 100);
		descripcionButton.setPosition(CAMERA_WIDTH / 2 - descripcionButton.getWidth() / 2, 200);
		relojButton.setPosition(CAMERA_WIDTH / 2 - relojButton.getWidth() / 2, 300);
		relojAleatorio.setPosition(CAMERA_WIDTH / 2 - relojButton.getWidth() / 2, 400);
		
		menuScene.addMenuItem(nombreButton);
		menuScene.addMenuItem(descripcionButton);
		menuScene.addMenuItem(relojButton);
		menuScene.addMenuItem(relojAleatorio);
		
		menuScene.buildAnimations();

		menuScene.setBackgroundEnabled(false);
		menuScene.setOnMenuItemClickListener(this);

		mainScene.setChildScene(menuScene);

		return mainScene;
	}
	
	@Override
	public boolean onMenuItemClicked(MenuScene pMenuScene, IMenuItem pMenuItem,
			float pMenuItemLocalX, float pMenuItemLocalY) {
		{
			switch (pMenuItem.getID())
			{
				case MENU_NUEVO:
					Menu.this.runOnUiThread(new Runnable() {
					    public void run() {

					        Intent intent = new Intent(Menu.this, Formulario.class);
					        startActivity(intent);
					        Menu.this.finish();

					    }
					});
					return true;
				case MENU_LISTA:
					Menu.this.runOnUiThread(new Runnable() {
					    public void run() {
					    	
					        Intent intent = new Intent(Menu.this, Lista.class);
					        startActivity(intent);
					        Menu.this.finish();

					    }
					});
					return true;
				case MENU_RELOJ:
					Menu.this.runOnUiThread(new Runnable() {
					    public void run() {
					    	
					    	Intent intent = new Intent(Menu.this, Reloj.class);
					        startActivity(intent);
					        Menu.this.finish();
					    }
					});
					return true;
				case MENU_ALEATORIO:
					Menu.this.runOnUiThread(new Runnable() {
					    public void run() {
					    	
					    	//Toast.makeText(Menu.this, "Se iniciaría la actividad Aleatorio", Toast.LENGTH_LONG).show();
					    	
					    	Intent intent = new Intent(Menu.this, Aleatorio.class);
					        startActivity(intent);
					        Menu.this.finish();
					    }
					});
					return true;
			}
			
			return false;
		}
	}
}
	
	