package com.example.pruebassicloud;

import java.io.IOException;
import org.andengine.audio.sound.Sound;
import org.andengine.audio.sound.SoundFactory;
import org.andengine.engine.camera.Camera;
import org.andengine.engine.options.EngineOptions;
import org.andengine.engine.options.ScreenOrientation;
import org.andengine.engine.options.resolutionpolicy.RatioResolutionPolicy;
import org.andengine.entity.scene.Scene;
import org.andengine.entity.scene.background.Background;
import org.andengine.entity.sprite.ButtonSprite;
import org.andengine.entity.sprite.ButtonSprite.OnClickListener;
import org.andengine.entity.text.Text;
import org.andengine.entity.text.TextOptions;
import org.andengine.opengl.font.Font;
import org.andengine.opengl.font.FontFactory;
import org.andengine.opengl.texture.atlas.bitmap.BitmapTextureAtlas;
import org.andengine.opengl.texture.atlas.bitmap.BitmapTextureAtlasTextureRegionFactory;
import org.andengine.opengl.texture.region.ITextureRegion;
import org.andengine.opengl.vbo.VertexBufferObjectManager;
import org.andengine.ui.activity.SimpleBaseGameActivity;
import org.andengine.util.HorizontalAlign;
import android.app.AlertDialog;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.Typeface;
import android.os.Handler;
import android.util.DisplayMetrics;
import android.widget.EditText;
import android.widget.Toast;

public class Reloj extends SimpleBaseGameActivity {

	private static int CAMERA_WIDTH;
	private static int CAMERA_HEIGHT;

	
	//FUENTES
	private Font  mFont;
	
	//SONIDO
	private Sound campana;
	
	//HILO
	Handler mHandler=new Handler();
	Text titulo;
	int i = 10;
	boolean dialogoAbierto = false;
	
	//BOTONES
	private BitmapTextureAtlas mBitmapTextureAtlas;
	private ITextureRegion mBotonTextureRegion;
	ButtonSprite botonTexto;
	
	AlertDialog.Builder builder;
	AlertDialog ald;
	EditText input;
	
	final Runnable r = new Runnable() {
		public void run() {
			if (i>0)
			{
				titulo.setText(Integer.toString(i));
				titulo.setPosition(CAMERA_WIDTH / 2 - titulo.getWidth() / 2, 20);
				i-=1;
			}
			else
			{
				titulo.setText(Integer.toString(i));
				titulo.setPosition(CAMERA_WIDTH / 2 - titulo.getWidth() / 2, 20);
				if (dialogoAbierto == true)
				{
					ald.dismiss();
					if (!input.getText().toString().equalsIgnoreCase(""))
					{
					Toast.makeText(Reloj.this, "Has enviado la palabra: "+input.getText().toString(), Toast.LENGTH_LONG).show();
					}
					else
					{
						Toast.makeText(Reloj.this, "¡No has escrito ninguna palabra!", Toast.LENGTH_LONG).show();
					}
				}
				else
				{
					Toast.makeText(Reloj.this, "¡No te ha dado tiempo a escribir ninguna palabra!", Toast.LENGTH_LONG).show();
				}
				//volverInicio();
				botonTexto.setVisible(false);
				Reloj.this.campana.play();
				i-=1;
			}			
		}
	};
	
	Thread thread = new Thread(){
		
		@Override
		public void run() {
			try{
				while(i>0){
					sleep(1000);
					mHandler.post(r);
				}
							}
			catch (Exception e) {
				// TODO: handle exception
			}
		}	
	};
	
		
	@Override
	public EngineOptions onCreateEngineOptions() {
		
		DisplayMetrics metrics = new DisplayMetrics();
		getWindowManager().getDefaultDisplay().getMetrics(metrics);
		CAMERA_WIDTH = metrics.widthPixels;
		CAMERA_HEIGHT = metrics.heightPixels;
		
		Camera camera = new Camera(0, 0, CAMERA_WIDTH, CAMERA_HEIGHT);
		
		
		 EngineOptions en = new EngineOptions(true, ScreenOrientation.LANDSCAPE_FIXED, new RatioResolutionPolicy(CAMERA_WIDTH, CAMERA_HEIGHT), camera);
		
		 en.getAudioOptions().setNeedsSound(true); 
		 
		return en;
	}
	

	@Override
	protected void onCreateResources() {
		BitmapTextureAtlasTextureRegionFactory.setAssetBasePath("gfx/");
		//BOTONES
		this.mBitmapTextureAtlas = new BitmapTextureAtlas(this.getTextureManager(),1024, 1024);
		  mBotonTextureRegion = BitmapTextureAtlasTextureRegionFactory.createFromAsset(this.mBitmapTextureAtlas, this,
		      "cuadrodetexto.png", 0, 0);
		  this.mBitmapTextureAtlas.load();
		
		
		this.mFont = FontFactory.create(this.getFontManager(), this.getTextureManager(), 256, 256, Typeface.create(Typeface.DEFAULT, Typeface.BOLD), 60, true, android.graphics.Color.GRAY);
		this.mFont.load();
		try {
			campana = SoundFactory.createSoundFromAsset(this.getSoundManager(), this.getApplicationContext(),
				     "mfx/ring.wav");
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
	}

	@Override
	protected Scene onCreateScene() {
		final Scene scene = new Scene();
		  
		  scene.setBackground(new Background(1, 1, 1));

		  final VertexBufferObjectManager vertexBufferObjectManager = this.getVertexBufferObjectManager();
		  
		  

		  botonTexto = new ButtonSprite(0,0, this.mBotonTextureRegion, this.getVertexBufferObjectManager());
		  botonTexto.setPosition(CAMERA_WIDTH / 2 - botonTexto.getWidth() / 2, CAMERA_HEIGHT / 2 - botonTexto.getHeight()/2);
		  botonTexto.setOnClickListener(new OnClickListener() {
			
			@Override
			public void onClick(ButtonSprite pButtonSprite, float pTouchAreaLocalX,
					float pTouchAreaLocalY) {
				Reloj.this.runOnUiThread(new Runnable() {
				       public void run() {
				    	   dialogoAbierto = true;
				    	   DialogRes(); 
				       }
			});
				
			}
		});
		  scene.attachChild(botonTexto);
		  scene.registerTouchArea(botonTexto);
		  
		  titulo = new Text(0, 0, this.mFont, "¡Tiempo!", new TextOptions(HorizontalAlign.CENTER), vertexBufferObjectManager);
		  scene.attachChild(titulo);
		  titulo.setPosition(CAMERA_WIDTH / 2 - titulo.getWidth() / 2, 20);	  	  
		  thread.start();
		  
		  
		  return scene;
		  
	}
	public void DialogRes(){
		builder = new AlertDialog.Builder(this);
		builder.setTitle("Inserte la palabra");
		builder.setMessage("Palabra:");
		input = new EditText(this);
		    builder.setView(input);
		    builder.setPositiveButton("Enviar", new DialogInterface.OnClickListener() {
				
				@Override
				public void onClick(DialogInterface dialog, int which) {
Toast.makeText(Reloj.this, "Has enviado la palabra correctamente: "+input.getText().toString(), Toast.LENGTH_LONG).show();
volverInicio();
				}
			});


ald = builder.show();
ald.show();
	}

@Override
public void onBackPressed()
{
	volverInicio();	
	
}
private void volverInicio(){
	Intent inten = new Intent(this, Menu.class);
	thread.interrupt();
	thread = null;
	startActivity(inten);
	this.finish();
}

}