package boccuz.rnn;

import java.awt.Font;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;

public final class Asset {
	private static final String ASSET_FOLDER = "assets/";
	private static final Map<String, Image> imageCache = new HashMap<String, Image>();
	private static final Map<String, Font> fontCache = new HashMap<String, Font>();

	public static final String FNT_GOCHI_HAND = "GochiHand-Regular.ttf";

	public static final String IMG_HOME_BACKGROUND = "accueil-fond.jpg";
	public static final String IMG_HOME_FOREGROUND = "accueil-top.png";
	public static final String IMG_HOME_SUN = "accueil-etoile.png";

	public static final String IMG_PLAY_BACKGROUND_1 = "fond-gateau.jpg";
	public static final String IMG_PLAY_HUD_SCORE = "plateau-score.png";
	public static final String IMG_PLAY_HUD_LEVEL = "nbvie.png";
	public static final String IMG_PLAY_HUD_TIMER = "timer.png";
	public static final String IMG_PLAY_HUD_TIMER_WHEEL = "timer-roue.png";
	public static final String IMG_PLAY_PLAYER = "player.png";

	public static final String IMG_GAME_OVER_BG = "game-over.jpg";
	public static final String IMG_GAME_OVER_CLOUD = "game-over-nuage.png";
	
	public static final String IMG_ANIM_LARDON = "lardon-4dir.png";
	 public static final String IMG_ANIM_MACARON = "macaron-4dir.png";
	 public static final String IMG_ANIM_PAINEPICE = "painepice-4dir.png";
	
	// public static final String IMG_ANIM_CUISTOT = "player.png";
	// public static final String IMG_ANIM_LARDON = "lardon-4dir.png";
	// public static final String IMG_ANIM_MACARON = "macaron-4dir.png";
	// public static final String IMG_ANIM_PAINEPICE = "painepice-4dir.png";
	// public static final String IMG_PLAYER = "player.png";
	// public static final String IMG_BULLET = "bullet.png";
	// public static final String IMG_ENEMY1 = "lardon_face.png";
	// public static final String IMG_ENEMY2 = "paindepiceface.png";
	// public static final String IMG_ENEMY3 = "macaronboss.png";
	// public static final String IMG_HOME_STAR = "accueil-etoile.png";
	// public static final String IMG_HOME_BG = "accueil-fond.jpg";
	// public static final String IMG_HOME_FG = "accueil-top.png";
	// public static final String IMG_SCORE_BG = "plateau-score.png";
	// public static final String IMG_TIMER = "timer.png";
	// public static final String IMG_TIME_TIMER = "timer-roue.png";
	// public static final String IMG_BACKGROUND_1 = "fond-gateau.jpg";
	// public static final String IMG_GAME_OVER = "game-over.jpg";
	// public static final String IMG_GAME_OVER_CLOUD = "game-over-nuage.png";
	// public static final String IMG_CHERRY = "cerise.png";
	// public static final String IMG_CHERRY_DROP_ZONE =
	// "incrustation-cerise.png";
	// public static final String IMG_LEVEL_BG = "nbvie.png";
	// public static final String IMG_VICTORY = "victoire.jpg";
	// public static final String IMG_DLC = "dlc.jpg";

	/**
	 * Load an asset and store it in cache
	 * 
	 * @param asset
	 * @throws SlickException
	 */
	public static void loadImage(String asset) throws SlickException {
		Image img = new Image(getResource(ASSET_FOLDER + asset), asset, false);
		imageCache.put(asset, img);
	}

	public static void loadImage(String asset, float scale)
			throws SlickException {
		Image img = new Image(getResource(ASSET_FOLDER + asset), asset, false);
		imageCache.put(asset, img.getScaledCopy(scale));
	}

	public static void loadFont(String name) {
		Font font;
		try {
			font = Font.createFont(Font.TRUETYPE_FONT,getResource(ASSET_FOLDER + name));
			fontCache.put(name, font);
		} catch (Exception e) {
			// TODO handle this error!
			e.printStackTrace();
		}
	}
	
	public static Font getFont(String name){
		Font fnt = fontCache.get(name);
		if (fnt == null) {
			loadFont(name);
			fnt = fontCache.get(name);
		}
		return fnt;
	}

	/**
	 * Retrieve an image from the cache
	 * 
	 * @param name
	 * @return
	 * @throws SlickException
	 */
	public static Image getImage(String name) throws SlickException {
		Image img = imageCache.get(name);
		if (img == null) {
			loadImage(name);
			img = imageCache.get(name);
		}
		return img;
	}

	private static InputStream getResource(String name) {
		return Asset.class.getResourceAsStream(name);
	}
}
