package boccuz.rnn;

public class Menu {
	private String[] items;
	private int index;
	private int size;

	public Menu(String[] items) {
		this.items = items;
		this.index = 0;
		this.size = items.length;
	}

	public void next(){
		update(1);
	}
	
	public void previous(){
		update(-1);
	}

	public String getItem(int index) {
		return items[index];
	}

	public int getIndex() {
		return index;
	}

	private void update(int delta) {
		index += delta;
		validateIndex();
	}
	
	private void validateIndex() {
		if (index >= size) {
			index = 0;
		} else if (index < 0) {
			index = size - 1;
		}
	}
}
