package boccuz.rnn;

import java.io.File;
import java.lang.reflect.Field;

import org.newdawn.slick.AppGameContainer;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.state.StateBasedGame;

import boccuz.rnn.state.GameOverState;
import boccuz.rnn.state.LoadingState;
import boccuz.rnn.state.MenuState;
import boccuz.rnn.state.PlayState;

public class RamNeumNeum extends StateBasedGame {
	private static final String LIBRARY_JNI_PATH = "java.library.path";
	private static final String LIBRARY_PATH = "native/";

	private static final String TEMP_JNI_PATH = "java.io.tmpdir";
	private static final String TEMP_PATH = "tmp/";

	public RamNeumNeum() {
		super("Ram Neum Neum!");

	}

	@Override
	public void initStatesList(GameContainer arg0) throws SlickException {
		this.addState(new LoadingState());
		this.addState(new MenuState());
		this.addState(new PlayState());
		this.addState(new GameOverState());

		this.enterState(State.PLAY.ordinal());
	}

	public static void main(String[] args) {
		// JNI initializations
		initJNI();

		AppGameContainer app;
		try {
			app = new AppGameContainer(new RamNeumNeum());
			app.setDisplayMode(Settings.WIDTH, Settings.HEIGHT, false);
			app.setFullscreen(Settings.FULL_SCREEN);
			app.setShowFPS(true);
			app.setMinimumLogicUpdateInterval(16);
			app.setTargetFrameRate(60);
			app.start();
		} catch (SlickException e) {
			// TODO Show error message properly
			e.printStackTrace();
		}
	}

	private static void initJNI() {
		// Some JNI for linking to the LWJGL lib
		String jlp = System.getProperty(LIBRARY_JNI_PATH);
		System.setProperty(LIBRARY_JNI_PATH, jlp + File.pathSeparatorChar
				+ LIBRARY_PATH);

		// Definition of the temp folder for the use of fonts. Must be defined
		// manually
		System.setProperty(TEMP_JNI_PATH, TEMP_PATH);
		// Create the temp folder
		File f = new File(TEMP_PATH);
		f.mkdir();

		Field fieldSysPath;
		try {
			fieldSysPath = ClassLoader.class.getDeclaredField("sys_paths");
			fieldSysPath.setAccessible(true);
			fieldSysPath.set(null, null);
		} catch (Exception e) {
			e.printStackTrace();
		}

		// // Test creating a temp file
		// try {
		// File.createTempFile("+~tempfileTEST", ".tmp", null);
		// } catch (IOException e) {
		// // TODO Auto-generated catch block
		// e.printStackTrace();
		// }

		System.out.println(LIBRARY_JNI_PATH + " -> " + LIBRARY_PATH);
		System.out.println(TEMP_JNI_PATH + " -> " + TEMP_PATH);
	}
}