package boccuz.rnn;

import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;

public class Viewport {
	public Vector2I viewportPos;
	public int viewWidth;
	public int viewHeight;

	public Viewport(int width, int height) {
		viewWidth = width;
		viewHeight = height;
		viewportPos = new Vector2I(0, 0);
	}

	/**
	 * Move the viewport with the given values
	 * 
	 * @param dx
	 *            X delta
	 * @param dy
	 *            Y delta
	 */
	public void move(int dx, int dy) {
		viewportPos.x += dx;
		viewportPos.y += dy;
	}

	/**
	 * Move the viewport to the given coordinates
	 * 
	 * @param x
	 *            X coordinate
	 * @param y
	 *            Y coordinate
	 */
	public void moveTo(int x, int y) {
		viewportPos.x = x;
		viewportPos.y = y;
	}

	/**
	 * Draw an entity into the viewport
	 * 
	 * @param e
	 *            The entity
	 * @param g
	 *            the graphic canvas
	 */
	public void draw(Entity2I e, Graphics g) {
		// 1. Coordinate transformation
		Vector2I pos = mapToScreen(e.getPosition());

		// 2. Rendering
		e.draw(pos, g);
	}

	/**
	 * Draw an image as background at [0,0] on the map
	 * 
	 * @param img
	 *            the background image
	 * @param g
	 *            the graphic canvas
	 */
	public void drawBackground(Image img, Graphics g) {
		Vector2I v = mapToScreen(new Vector2I(0, 0));
		g.drawImage(img, v.x, v.y);
	}

	/**
	 * Transform a map coordinate to the screen offset.
	 * 
	 * @param v
	 *            the vector to transform
	 * @return the transformed value
	 */
	public Vector2I mapToScreen(Vector2I v) {
		Vector2I v2 = new Vector2I(v.x, v.y);
		v2.x += viewportPos.x;
		v2.y += viewportPos.y;

		// if (v2.x < 0 || v2.x > Settings.WIDTH || v2.y < 0
		// || v2.y > Settings.HEIGHT) {
		// // The position is outside of the screen. Return null
		// return null;
		// }

		return v2;
	}
}
