package boccuz.rnn.helper;

import java.awt.Color;

import org.newdawn.slick.SlickException;
import org.newdawn.slick.UnicodeFont;
import org.newdawn.slick.font.effects.ColorEffect;

import boccuz.rnn.Asset;

public class FontHelper {
	
	@SuppressWarnings("unchecked")
	public static UnicodeFont get(String name, int size, boolean bold, boolean italic, org.newdawn.slick.Color color) throws SlickException{
		UnicodeFont font = new UnicodeFont(Asset.getFont(name), size, bold, italic);
		font.addAsciiGlyphs();
		font.getEffects().add(new ColorEffect(convert(color)));
		font.loadGlyphs();
		return font;
	}
	
	public static Color convert(org.newdawn.slick.Color c) {
		return new Color(c.getRed(), c.getGreen(), c.getBlue(), c.getAlpha());
	}
}
