package boccuz.rnn.state;

import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.state.BasicGameState;
import org.newdawn.slick.state.StateBasedGame;

import boccuz.rnn.Asset;
import boccuz.rnn.State;

public class GameOverState extends BasicGameState {
	private Image cloud;
	private int cloudX;
	private int cloudY;
	private int maxY = 20;
	private float cloudScale;
	private boolean cloudUp;
	private boolean moveUp;
	private int cloudMoveCounter;

	@Override
	public void init(GameContainer arg0, StateBasedGame arg1)
			throws SlickException {
		cloud = Asset.getImage(Asset.IMG_GAME_OVER_CLOUD);
		cloudX = 460;
		cloudY = 200;
		cloudScale = 0.5F;
		cloudUp = false;
		moveUp = false;
		cloudMoveCounter = 0;
	}

	@Override
	public void render(GameContainer arg0, StateBasedGame arg1, Graphics arg2)
			throws SlickException {
		Asset.getImage(Asset.IMG_GAME_OVER_BG).draw();
		cloud.draw(cloudX, cloudY, cloudScale);
	}

	@Override
	public void update(GameContainer arg0, StateBasedGame arg1, int arg2)
			throws SlickException {
		if(cloudUp){
			cloudMoveCounter++;
			if(moveUp){
				// Move the cloud up
				if(cloudMoveCounter == 3){
					cloudY--;
					cloudMoveCounter = 0;
				}
				if(cloudY <= 0){
					moveUp = !moveUp;
				}
			}else{
				// Move the cloud down
				if(cloudMoveCounter == 3){
					cloudY++;
					cloudMoveCounter = 0;
				}
				if(cloudY >= 40){
					moveUp = !moveUp;
				}
			}
		}else{
			if(cloudY > maxY){
				cloudY--;
				if(cloudY %2 == 0){
					cloudX--;
				}
				cloudScale += 0.01F;
			}else{
				cloudUp = true;
			}
		}
	}

	@Override
	public int getID() {
		return State.GAME_OVER.ordinal();
	}

}
