package rcpexplorer.views;

import org.eclipse.core.runtime.IExtension;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class CopyExtensionAction implements IObjectActionDelegate {
	private IExtension extension;
	private BEPEBView view;

	public CopyExtensionAction() {
	}

	public void setActivePart(IAction action, IWorkbenchPart targetPart) {
		this.view = null;
		if (targetPart instanceof BEPEBView) {
			this.view = (BEPEBView)targetPart;
		}
	}

	public void run(IAction action) {
		if (extension != null || view == null) {
			String xml = toXml(extension);
			// Get Clipboard
			Clipboard clipboard = new Clipboard(PlatformUI.getWorkbench()
					.getActiveWorkbenchWindow().getShell().getDisplay());
			// Put the paths string into the Clipboard
			clipboard.setContents(new Object[] { xml },
					new Transfer[] { TextTransfer.getInstance() });
		}
	}

	private String toXml(IExtension extension) {
		if (extension == null) {
			return "";
		}
		
		StringBuilder stringBuilder = new StringBuilder();
		BEPEBView.toXml(extension, stringBuilder);		
		return stringBuilder.toString();
	}

	public void selectionChanged(IAction action, ISelection selection) {
		extension = null;
		action.setEnabled(false);
		if (selection instanceof ITreeSelection) {
			ITreeSelection treeSelection = (ITreeSelection) selection;
			TreePath[] paths = treeSelection.getPaths();
			if (paths.length > 0) {
				Object lastSegment = paths[0].getLastSegment();
				if (lastSegment instanceof IExtension) {
					extension = ((IExtension) lastSegment);
					action.setEnabled(true);
				} else if (lastSegment instanceof AsExtensionIn) {
					extension = ((AsExtensionIn) lastSegment).extension;
					action.setEnabled(true);					
				} else if (lastSegment instanceof AsExtensionOf) {
					extension = ((AsExtensionOf) lastSegment).extension;
					action.setEnabled(true);					
				}
			}
		}		
	}
}
