package fi.ribanoz.GUI;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.awt.event.FocusListener;
import java.awt.event.FocusEvent;
import fi.ribanoz.database.*;
import fi.ribanoz.office.SECRETARY;

import java.util.*;

public class GUI extends JFrame {
	// OBJECTS
	SQL sql = new SQL();
	private ArrayList<String> results = new ArrayList();

	// FRAME 1
	private static final long serialVersionUID = 1L;
	private JPanel pane = new JPanel();
	private JButton button = new JButton("Clear");
	private JLabel label = new JLabel("Ribanoz Softworks");
	private JTextField input = new JTextField(25);
	private JTextArea output = new JTextArea(15, 75);
	private JScrollPane scrollPane = new JScrollPane(output);
	private String inputString;
	private String outputString;
	private JButton addUser = new JButton("add user");

	// FRAME 2
	private JTextField fname = new JTextField("First name");
	private JTextField lname = new JTextField("Last name");
	private JButton saveButton = new JButton("save");
	private JTextField address = new JTextField("address");
	private JTextField postcode = new JTextField("postcode");
	private JTextField postarea = new JTextField("postarea");
	private JTextField phone = new JTextField("phone");
	private JTextField email = new JTextField("email");
	private JButton updateButton = new JButton("Update info");

	// getter and setter
	public String getOutputString() {
		return outputString;
	}

	public void setOutputString(String outputString) {
		this.outputString = outputString;
	}

	// first frame. This is called in main
	public void Frame1() {

		setBounds(400, 400, 900, 400);
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		// pane.setLayout(new GridLayout(3,2));

		Container con = this.getContentPane();
		button.addActionListener(new buttonListener());
		pane.add(button);
		addUser.addActionListener(new addUserListener());
		pane.add(addUser);
		input.addActionListener(new textFieldListener());
		// button.addFocusListener(new focusListener());
		pane.add(label);
		pane.add(input);
		pane.add(output);
		pane.add(scrollPane);
		input.requestFocus();
		output.setEditable(false);
		output.setWrapStyleWord(true);
		con.add(pane);
		setVisible(true);
	}

	public void frame2() {
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		JFrame frame = new JFrame();
		JPanel pane = new JPanel();
		JLabel lb = new JLabel("Add Users");
		saveButton.addActionListener(new saveNewUserListener());
		pane.add(lb);
		pane.add(saveButton);
		pane.add(fname);
		pane.add(lname);
		pane.add(address);
		pane.add(postcode);
		pane.add(postarea);
		pane.add(phone);
		pane.add(email);
		//pane.add(updateButton);
		frame.setBounds(400, 400, 400, 400);
		frame.add(pane);
		frame.setVisible(true);
	}

	public void parseArray(ArrayList<String> res) {
		for (String line : res) {
			output.append(line + "\n");
		}
		res.clear();
	}

	// action events
	private class textFieldListener implements ActionListener {
		public void actionPerformed(ActionEvent e) {

			inputString = input.getText();
			input.setText("");
			sql.setFieldValue(inputString);
			try {
				results = sql.selectOperation();
				parseArray(results);
			} catch (Exception e1) {
				System.out.println("GUI:s Catch");
			}
		}
	}

	// button listener
	private class buttonListener implements ActionListener {
		public void actionPerformed(ActionEvent e) {
			// button.setText("Cleared");
			// parseData();
			output.setText(null);
			button.setText("Clear");
		}
	}

	private class focusListener extends FocusAdapter {
		public void focusGained(FocusEvent e) {
			output.append(e.getComponent().getClass().getName()
					+ "focus gained");
		}

		public void focusLost(FocusEvent e) {
			output.append(e.getComponent().getClass().getName() + "focus lost");
		}
	}

	private class addUserListener implements ActionListener {
		public void actionPerformed(ActionEvent e) {
			frame2();
		}
	}

	// save new user listener
	private class saveNewUserListener implements ActionListener {
		public void actionPerformed(ActionEvent e) {
			sql.setFname(fname.getText());
			sql.setSurname(lname.getText());
			sql.setAddress(address.getText());
			sql.setPostcode(postcode.getText());
			sql.setPostarea(postarea.getText());
			sql.setPhone(phone.getText());
			sql.setEmail(email.getText());
			sql.insertCustomer();
		}
	}
}
