/*
 * TortueDessin.java
 *
 * Created on 20 mars 2008, 09:27
 */

package ihm;

import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Iterator;
/*



 *
 * @author  philippe
 */
import upmc.li260.langage.Position;
import upmc.li260.langage.Tortue;
public class TortueDessin extends javax.swing.JFrame implements IUpdate {
    
    ArrayList <Line> lines;
    Tortue t;
    
    public TortueDessin(Line ligne){
        this.lines.add(ligne);
        initComponents();
    }
    
    /** Creates new form TortueDessin */
    public TortueDessin(Tortue t) {
        this.t=t;
        initComponents();
        lines =new ArrayList<Line>();
    }

   
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        jPanel1 = new javax.swing.JPanel();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 421, Short.MAX_VALUE)
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 0, Short.MAX_VALUE)
        );

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jPanel1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addGap(361, 361, 361)
                .addComponent(jPanel1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        pack();
    }// </editor-fold>//GEN-END:initComponents

   
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel jPanel1;
    // End of variables declaration//GEN-END:variables
    @Override
    public void paint(Graphics g)
    {
        super.paint(g);
        
        int xa=(int)(t.getPosition().getPx()+15 *(Math.cos(Math.toRadians(t.getOrientation()))));
        int xb=(int)(t.getPosition().getPx()+15 *(Math.cos(Math.toRadians(t.getOrientation()+135))));
        int xc=(int)(t.getPosition().getPx()+15*(Math.cos(Math.toRadians(t.getOrientation()+225))));
        
        int ya=(int)(t.getPosition().getPy()+15 *(Math.sin(Math.toRadians(t.getOrientation()))));
        int yb=(int)(t.getPosition().getPy()+15 *(Math.sin(Math.toRadians(t.getOrientation()+135))));
        int yc=(int)(t.getPosition().getPy()+15*(Math.sin(Math.toRadians(t.getOrientation()+225))));
        
        
        int[] xPoints = {xa,xb,xc};
        int[] yPoints={ya,yb,yc};
        
       
        g.drawPolygon(xPoints,yPoints,3);
        //g.drawOval(t.getPosition().getPx()-7,t.getPosition().getPy()-7, 15,15);
       if (!(t.isStylo())){
           g.drawOval(t.getPosition().getPx(),t.getPosition().getPy(), 5,5);
           lines.add(new Line((double)t.getAnciennePosition().getPx(),(double)t.getAnciennePosition().getPy(),(double)t.getPosition().getPx(),(double)t.getPosition().getPy()));
            g.drawPolygon(xPoints,yPoints,3);
            //g.drawOval(t.getPosition().getPx()-7,t.getPosition().getPy()-7, 15,15);
           //g.drawLine(t.getPosition().getPx()-7,t.getPosition().getPy()-7,(int)(15*Math.cos(Math.toRadians(t.getOrientation()))),(int)(15*Math.sin(Math.toRadians(t.getOrientation()))));
       
       }
       else {
            g.drawPolygon(xPoints,yPoints,3); //g.drawOval(t.getPosition().getPx()-7,t.getPosition().getPy()-7, 15,15);
            g.drawOval(t.getPosition().getPx()-2,t.getPosition().getPy()-3, 5,5);
       }
           
       
      Iterator it=lines.iterator();
      Line li;
      while(it.hasNext()){
          li=(Line)it.next();
          g.drawLine((int)li.getX1(),(int)li.getY1(),(int)li.getX2(),(int)li.getY2());    
          
     }
      
    }
    
    
    public void update() {
       Graphics g=this.jPanel1.getGraphics();
       this.paint(g) ;
        
    
    
}}
