/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package upmc.li260.ihm;

import java.awt.Robot;
import upmc.li260.robot.RobotGuide;

/**
 * Classe permettant de diriger un robot  distance grce au clavier.
 * @author Philippe
 */
public class Pilotage {
    /** Stratégie de control pour ce conducteur */
	protected StrategieControl control;
    /** Robot qui sera tlguid**/
	private RobotGuide robot;
        
        
    /**
     * Initialise une instance de Pilotage avec le robot  guider.
     * @param robot
     */
	public Pilotage(RobotGuide robot) {
            control= new StrategieControlClavier();
            control.setConducteur(this);
            this.robot=robot;
        }
	
	/**
	 * Modifie la stratégie de controle pour ce conducteur
	 * 
	 * @param stratégie de control
	 */
	public void setControl(StrategieControl ctrl) {
		control = ctrl;
	}
	
	
	/**
	 * Renvoie la strategie de controle courante
	 * @return Strategie de controle
	 */
	public StrategieControl getControl() {
		return control;
		
	}
	
	
	
	/**
	 * Mthode qui dit au robot de tourner  gauche
         * @return void
	 */
	public void tournerGauche() {
		robot.tournerGaucheGuide();
	}
	
	/**
         * Mthode qui dit au robot de tourner  droite
         * @return void
	 */
	public void tournerDroite() {
		robot.tournerDroiteGuide();
	}
	
	/**
	 * Mthode qui dit au robot d'avancer.
	 */
	public void avancer() {
		robot.avanceGuide();
	}
	
	/**
	 * Mthode qui dit au robot de reculer.
	 * 
	 * 				
	 */
	public void reculer() {
		robot.reculeGuide();
	}
        /**
         * Immobilise le robot.
         */
        public void stop(){
            robot.stop();
        }
}
