package upmc.li260.ihm;
/*
 * ProgrammeConstructor.java
 *
 * Created on 28 février 2008, 09:31
 */
import java.awt.Color;
import javax.swing.JTextField;
import upmc.li260.mvc.Controller;
import upmc.li260.mvc.IUpdate;
import upmc.li260.langage.*;
import upmc.li260.langage.Programme;
import upmc.li260.langage.logo.MauvaiseCommandeException;




/**
 * Classe qui affiche la fentre de construction du programme pour un effecteur.
 * @author  2500397
 */
public class ProgrammeConstructor extends java.awt.Frame implements IUpdate {
    /** Langage dans lequel sont prises les commandes**/
    Langage l=new Langage();
    /** Programme reprsentant la srie de commandes  effectuer**/
    Programme programme;
    /** Effecteur qui executera les commandes**/
    IEffecteur eff1;
    
    
    /**
     * Creates new form ProgrammeConstructor
     */
   public ProgrammeConstructor(Programme programme,IEffecteur eff1)throws MauvaiseCommandeException {
        initComponents();
        
        this.eff1=eff1;
        Controller cont =new Controller(this);
        this.programme= new Programme(l);
        Reculer.addActionListener(cont);
        avancer.addActionListener(cont);
        tournerDroite.addActionListener(cont);
        tournerGauche.addActionListener(cont);
        abaisser.addActionListener(cont);
        lever.addActionListener(cont);
        Retirer.addActionListener(cont);
        run.addActionListener(cont);
        Reset.addActionListener(cont);
        stop.addActionListener(cont);
        droiteAngle.addMouseListener(cont);
        gaucheAngle.addMouseListener(cont);
        pasAvancer.addMouseListener(cont);
        pasReculer.addMouseListener(cont);
        jDialog1.addMouseListener(cont);
        jOptionPane1.addMouseListener(cont);
        
    }
    
    
    /**
     * Mthode qui permet dans ce cas d'actualiser la vue, ici la liste de commandes sur l'ihm.
     * @param type
     */
    public void update(String type){
        liste.removeAll();
        liste.setListData(programme.getProgramme());
        
    }
    
    
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jDialog1 = new javax.swing.JDialog();
        jOptionPane1 = new javax.swing.JOptionPane();
        jPanel1 = new javax.swing.JPanel();
        jScrollPane1 = new javax.swing.JScrollPane();
        liste = new javax.swing.JList();
        Reset = new javax.swing.JButton();
        Retirer = new javax.swing.JButton();
        jPanel7 = new javax.swing.JPanel();
        avancer = new javax.swing.JButton();
        pasAvancer = new javax.swing.JTextField();
        jPanel9 = new javax.swing.JPanel();
        lever = new javax.swing.JButton();
        jPanel11 = new javax.swing.JPanel();
        tournerGauche = new javax.swing.JButton();
        gaucheAngle = new javax.swing.JTextField();
        jPanel13 = new javax.swing.JPanel();
        tournerDroite = new javax.swing.JButton();
        droiteAngle = new javax.swing.JTextField();
        jPanel15 = new javax.swing.JPanel();
        Reculer = new javax.swing.JButton();
        pasReculer = new javax.swing.JTextField();
        jPanel17 = new javax.swing.JPanel();
        abaisser = new javax.swing.JButton();
        run = new javax.swing.JButton();
        stop = new javax.swing.JButton();
        jProgressBar1 = new javax.swing.JProgressBar();

        jDialog1.setAlwaysOnTop(true);
        jDialog1.getContentPane().setLayout(new org.netbeans.lib.awtextra.AbsoluteLayout());
        jDialog1.getContentPane().add(jOptionPane1, new org.netbeans.lib.awtextra.AbsoluteConstraints(70, 90, -1, -1));

        setBackground(java.awt.Color.lightGray);
        setLocationRelativeTo(null);
        setMinimumSize(new java.awt.Dimension(500, 380));
        setResizable(false);
        setTitle("ProgrammeConstructor"); // NOI18N
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                exitForm(evt);
            }
        });
        setLayout(new org.netbeans.lib.awtextra.AbsoluteLayout());

        jPanel1.setBackground(new java.awt.Color(102, 102, 102));
        jPanel1.setLayout(new org.netbeans.lib.awtextra.AbsoluteLayout());

        liste.setBorder(javax.swing.BorderFactory.createEtchedBorder());
        jScrollPane1.setViewportView(liste);

        jPanel1.add(jScrollPane1, new org.netbeans.lib.awtextra.AbsoluteConstraints(10, 10, 170, 250));

        Reset.setBackground(new java.awt.Color(204, 204, 204));
        Reset.setText("Reset"); // NOI18N
        jPanel1.add(Reset, new org.netbeans.lib.awtextra.AbsoluteConstraints(10, 270, 80, 20));

        Retirer.setBackground(new java.awt.Color(204, 204, 204));
        Retirer.setText("-"); // NOI18N
        jPanel1.add(Retirer, new org.netbeans.lib.awtextra.AbsoluteConstraints(130, 270, 50, 20));

        add(jPanel1, new org.netbeans.lib.awtextra.AbsoluteConstraints(10, 40, 190, 300));

        jPanel7.setBackground(new java.awt.Color(153, 153, 153));
        jPanel7.setLayout(new org.netbeans.lib.awtextra.AbsoluteLayout());

        avancer.setBackground(new java.awt.Color(204, 204, 204));
        avancer.setText("Avancer"); // NOI18N
        jPanel7.add(avancer, new org.netbeans.lib.awtextra.AbsoluteConstraints(10, 10, 120, 20));

        pasAvancer.setText("Pas?"); // NOI18N
        jPanel7.add(pasAvancer, new org.netbeans.lib.awtextra.AbsoluteConstraints(140, 10, 120, 20));

        add(jPanel7, new org.netbeans.lib.awtextra.AbsoluteConstraints(210, 40, 270, 40));

        jPanel9.setBackground(new java.awt.Color(153, 153, 153));
        jPanel9.setLayout(new org.netbeans.lib.awtextra.AbsoluteLayout());

        lever.setBackground(new java.awt.Color(204, 204, 204));
        lever.setText("Lever"); // NOI18N
        jPanel9.add(lever, new org.netbeans.lib.awtextra.AbsoluteConstraints(10, 10, 110, 20));

        add(jPanel9, new org.netbeans.lib.awtextra.AbsoluteConstraints(210, 240, 130, 40));

        jPanel11.setBackground(new java.awt.Color(153, 153, 153));
        jPanel11.setLayout(new org.netbeans.lib.awtextra.AbsoluteLayout());

        tournerGauche.setBackground(new java.awt.Color(204, 204, 204));
        tournerGauche.setText("TournerGauche"); // NOI18N
        jPanel11.add(tournerGauche, new org.netbeans.lib.awtextra.AbsoluteConstraints(10, 10, 120, 20));

        gaucheAngle.setText("Angle de?"); // NOI18N
        jPanel11.add(gaucheAngle, new org.netbeans.lib.awtextra.AbsoluteConstraints(140, 10, 120, 20));

        add(jPanel11, new org.netbeans.lib.awtextra.AbsoluteConstraints(210, 190, 270, 40));

        jPanel13.setBackground(new java.awt.Color(153, 153, 153));
        jPanel13.setLayout(new org.netbeans.lib.awtextra.AbsoluteLayout());

        tournerDroite.setBackground(new java.awt.Color(204, 204, 204));
        tournerDroite.setText("TournerDroite"); // NOI18N
        jPanel13.add(tournerDroite, new org.netbeans.lib.awtextra.AbsoluteConstraints(10, 10, 120, 20));

        droiteAngle.setText("Angle de?"); // NOI18N
        jPanel13.add(droiteAngle, new org.netbeans.lib.awtextra.AbsoluteConstraints(140, 10, 120, 20));

        add(jPanel13, new org.netbeans.lib.awtextra.AbsoluteConstraints(210, 140, 270, 40));

        jPanel15.setBackground(new java.awt.Color(153, 153, 153));
        jPanel15.setLayout(new org.netbeans.lib.awtextra.AbsoluteLayout());

        Reculer.setBackground(new java.awt.Color(204, 204, 204));
        Reculer.setText("Reculer"); // NOI18N
        jPanel15.add(Reculer, new org.netbeans.lib.awtextra.AbsoluteConstraints(10, 10, 120, 20));

        pasReculer.setText("Pas?"); // NOI18N
        jPanel15.add(pasReculer, new org.netbeans.lib.awtextra.AbsoluteConstraints(140, 10, 120, 20));

        add(jPanel15, new org.netbeans.lib.awtextra.AbsoluteConstraints(210, 90, 270, 40));

        jPanel17.setBackground(new java.awt.Color(153, 153, 153));
        jPanel17.setLayout(new org.netbeans.lib.awtextra.AbsoluteLayout());

        abaisser.setBackground(new java.awt.Color(204, 204, 204));
        abaisser.setText("Abaisser"); // NOI18N
        jPanel17.add(abaisser, new org.netbeans.lib.awtextra.AbsoluteConstraints(10, 10, 110, 20));

        add(jPanel17, new org.netbeans.lib.awtextra.AbsoluteConstraints(210, 290, 130, 40));

        run.setBackground(new java.awt.Color(0, 153, 0));
        run.setText("Run"); // NOI18N
        run.setBorder(new javax.swing.border.SoftBevelBorder(javax.swing.border.BevelBorder.RAISED));
        add(run, new org.netbeans.lib.awtextra.AbsoluteConstraints(360, 240, 120, 40));

        stop.setBackground(new java.awt.Color(204, 0, 0));
        stop.setText("stop"); // NOI18N
        add(stop, new org.netbeans.lib.awtextra.AbsoluteConstraints(360, 290, 120, 30));

        jProgressBar1.setBackground(new java.awt.Color(255, 255, 255));
        jProgressBar1.setForeground(new java.awt.Color(255, 153, 102));
        add(jProgressBar1, new org.netbeans.lib.awtextra.AbsoluteConstraints(20, 350, 460, 10));

        pack();
    }// </editor-fold>//GEN-END:initComponents
/*    */
    /** Exit the Application */
    private void exitForm(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_exitForm
        System.exit(0);
    }//GEN-LAST:event_exitForm
    
    /**
     * @param args the command line arguments
     */
    /*public static void main(String args[]) {
        java.awt.EventQueue.invokeLater(new Runnable() {
     
            public void run() {
                new ProgrammeConstructor(programme).setVisible(true);
            }
        });
    }*/
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton Reculer;
    private javax.swing.JButton Reset;
    private javax.swing.JButton Retirer;
    private javax.swing.JButton abaisser;
    private javax.swing.JButton avancer;
    private javax.swing.JTextField droiteAngle;
    private javax.swing.JTextField gaucheAngle;
    public javax.swing.JDialog jDialog1;
    public javax.swing.JOptionPane jOptionPane1;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel11;
    private javax.swing.JPanel jPanel13;
    private javax.swing.JPanel jPanel15;
    private javax.swing.JPanel jPanel17;
    private javax.swing.JPanel jPanel7;
    private javax.swing.JPanel jPanel9;
    public javax.swing.JProgressBar jProgressBar1;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JButton lever;
    private javax.swing.JList liste;
    private javax.swing.JTextField pasAvancer;
    private javax.swing.JTextField pasReculer;
    private javax.swing.JButton run;
    private javax.swing.JButton stop;
    private javax.swing.JButton tournerDroite;
    private javax.swing.JButton tournerGauche;
    // End of variables declaration//GEN-END:variables
    
    
    /**
     * Accesseur de l'effecteur
     * @return
     */
    public IEffecteur getEff1(){
        return this.eff1;
    }
   
    /**
     * Accesseur de angle  droite
     * @return droiteAngle
     */
    public JTextField getDroiteAngle() {
        return droiteAngle;
    }
    
    /**
     * Accesseur de angle  gauche
     * @return gaucheAngle
     */
    public JTextField getGaucheAngle() {
        return gaucheAngle;
    }
    /**
     * Accesseur du nombre de pas  avancer.
     * @return pasAvancer
     */
    public JTextField getPasAvancer() {
        return pasAvancer;
    }
    /**
     * Accesseur du nombre de pas  reculer
     * @return pasReculer
     */
    public JTextField getPasReculer() {
        return pasReculer;
    }
    /**
     * Accesseur du programme
     * @return le programme
     */
    public Programme getProgramme() {
        return programme;
    }
    
}
