/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package upmc.li260.ihm;

/**
 * Classe abstraiste reprsentant un moyen de guider le robot (design pattern stratgie).
 * @author Philippe
 */
public abstract class StrategieControl {
    /** defini le pilote du robot **/
    protected Pilotage conducteur = null;
	
	
	
	public StrategieControl() {
	}
	
	/**
	 * Ce controle est-il associé à un conducteur ?
	 * 
	 * @return vrai si cette stratégie est associée à un conducteur
	 */
	public boolean hasConducteur() {
		return (conducteur != null);
	}

	/**
	 * Renvoie le conducteur associé à ce controle
	 * 
	 * @return le conducteur
	 */
	public Pilotage getConducteur() {
		return conducteur;
	}

	/**
	 * Change le conducteur associé à ce contrôle
	 * 
	 * @param conducteur 
	 * 					le conducteur à associer
	 */
	public void setConducteur(Pilotage conducteur) {
		this.conducteur = conducteur;
		this.conducteur.setControl(this);
	}
}
