/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package upmc.li260.langage;

import ihm.Model;
import upmc.li260.langage.logo.CommandeAvecParametre;
import upmc.li260.langage.logo.MauvaiseCommandeException;

/**
 *
 * @author philippe
 */
public class Tortue extends Model implements IEffecteur {
       private int orientation ;
       private Position position;
       private boolean stylo;
       private Position anciennePosition;
    
       public Tortue(int orientation, Position position, boolean stylo) {
        this.orientation = orientation;
        this.position = position;
        this.stylo = stylo;
    }

    public Position getAnciennePosition() {
        return anciennePosition;
    }

   
   
       
       
       
    public float getOrientation() {
        return orientation;
    }

    public Position getPosition() {
        return position;
    }

    public boolean isStylo() {
        return stylo;
    }
       
   public void execute(Commande c)throws MauvaiseCommandeException{
       this.anciennePosition=this.position.copy(); 
       if (c.getNom().equals("Bouger")) {
            int pas = ((CommandeAvecParametre)c).getParametreInt().getPas();
            this.position.setPx((int)(this.position.getPx()+pas*Math.cos(Math.toRadians(orientation))));
            this.position.setPy((int)(this.position.getPy()+pas*Math.sin(Math.toRadians(orientation))));
            
        }
       
        if (c.getNom().equals("Tourner")) {
            int pas = ((CommandeAvecParametre)c).getParametreInt().getPas();
            this.orientation=(this.orientation+pas)%360;           
        }
       
        if (c.getNom().equals("Abaisser")) {
            this.stylo=false;
            
            
        }
        if (c.getNom().equals("Lever")) {
            this.stylo=true;
            
        }
        this.changed();
        
   }
    
     
    public void executeCommande(Commande c){
        Langage l=new Langage();
        DecodeurTortue eg=new DecodeurTortue(l);
        try{
            if(c instanceof CommandeAvecParametre){
                CommandeAvecParametre res;
                res=(CommandeAvecParametre) eg.decodeCmd(c);
                this.execute(res);
            }
            else{
                Commande res;
                res=eg.decodeCmd(c);
                this.execute(res);
            }
            
            }   
        catch(MauvaiseCommandeException e){
                System.out.println("mauvaise commande");
           
            
        }    
        
    }

    public String toString(){
        return ("position:"+" "+this.getOrientation()+" "+getPosition().toString()+" "+isStylo());
    }
}
