/*
 * TortueDessin.java
 *
 * Created on 20 mars 2008, 09:27
 */

package upmc.li260.tortue;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.KeyListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import upmc.li260.ihm.Pilotage;
import upmc.li260.imageutil.ImageUtil;

import upmc.li260.mvc.IUpdate;
import upmc.li260.robot.Robot;
/*



 *
 * @author  philippe
 */
import upmc.li260.langage.Position;

public class TortueDessin extends javax.swing.JFrame implements IUpdate {
    
    ArrayList <Line> lines;
    Tortue t;
    private Image sol;
    private int yrob=133;
    private int xrob=100;
    private Image robot;
    private BufferedImage cachedImage;
    
    
    public TortueDessin(Line ligne){
        this.lines.add(ligne);
        initComponents();
        
        
       
    }
    
    /** Creates new form TortueDessin */
    public TortueDessin(Tortue t) throws IOException {
        this.t=t;
        initComponents();
        lines =new ArrayList<Line>();
        sol = ImageUtil.getImage("/divers/sol.jpg");
       robot = ImageUtil.getImage("/divers/minirobot.png");
            
            cachedImage = ImageUtil.toBufferedImage(robot);
        
        
    }
    
         
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jPanel1 = new javax.swing.JPanel();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setMinimumSize(new java.awt.Dimension(800, 800));

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 421, Short.MAX_VALUE)
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 0, Short.MAX_VALUE)
        );

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jPanel1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addGap(361, 361, 361)
                .addComponent(jPanel1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

   
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel jPanel1;
    // End of variables declaration//GEN-END:variables
    @Override
    
    public void paint(Graphics g){ 
    super.paint(g);
        g.drawImage(sol,0,0,null);
        Image robot;
        Image imageToDraw= ImageUtil.getRotatedImage(cachedImage,(long)t.getOrientation()-90);
        g.drawImage(imageToDraw,t.getPosition().getPx()-(xrob/2),t.getPosition().getPy()-(yrob/2),null);
        
        
        /**
         * Partie du code qui dessinait le triangle orient
        
        int xa=(int)(t.getPosition().getPx()+15 *(Math.cos(Math.toRadians(t.getOrientation()))));
        int xb=(int)(t.getPosition().getPx()+15 *(Math.cos(Math.toRadians(t.getOrientation()+135))));
        int xc=(int)(t.getPosition().getPx()+15*(Math.cos(Math.toRadians(t.getOrientation()+225))));
        
        int ya=(int)(t.getPosition().getPy()+15 *(Math.sin(Math.toRadians(t.getOrientation()))));
        int yb=(int)(t.getPosition().getPy()+15 *(Math.sin(Math.toRadians(t.getOrientation()+135))));
        int yc=(int)(t.getPosition().getPy()+15*(Math.sin(Math.toRadians(t.getOrientation()+225))));
        int[] xPoints = {xa,xb,xc};
        int[] yPoints={ya,yb,yc};
        
        g.drawPolygon(xPoints,yPoints,3); 
        
        
        **/
        
        if (t.isStylo()){
          
           lines.add(new Line((double)t.getAnciennePosition().getPx(),(double)t.getAnciennePosition().getPy(),(double)t.getPosition().getPx(),(double)t.getPosition().getPy()));
            //g.drawPolygon(xPoints,yPoints,3);
            g.drawImage(imageToDraw,t.getPosition().getPx()-(xrob/2),t.getPosition().getPy()-(yrob/2),null);
           
            
       
       }
       else {
            //g.drawPolygon(xPoints,yPoints,3); 
             g.drawImage(imageToDraw,t.getPosition().getPx()-(xrob/2),t.getPosition().getPy()-(yrob/2),null);
               
           
       }
           
       
      Iterator it=lines.iterator();
      Line li;
      while(it.hasNext()){
          li=(Line)it.next();
          g.drawLine((int)li.getX1(),(int)li.getY1(),(int)li.getX2(),(int)li.getY2());    
          
     }
    
    }
    
    
    public void update(String type){
       Graphics g=this.jPanel1.getGraphics();
       
       this.paint(g) ;
       this.repaint();
        
}

    public void abonner(Robot gravier) {
        throw new UnsupportedOperationException("Not yet implemented");
    }
}
