/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package vocabulary;

import method.DbOperation;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.sql.*;
import java.util.regex.*;

/**
 *
 * @author Administrator
 */
class EditWordDialog extends JDialog implements ActionListener {

    JTextField spelling;
    JTextArea meaning;
    JButton ok, cancel;
    JTable table;
    MyTableModel tableModel;
    String levelInner[] = {"简单", "中等", "高级"};
    JComboBox inner = new JComboBox(levelInner);
    String currentLevel;
    String bookid;
    String levelOptionInParent;

    EditWordDialog(MainFrame owner, JTable table, MyTableModel tableModel, String bookid, String levelOptionInParent) {
        setTitle("编辑单词");
        this.table = table;
        this.tableModel = tableModel;
        this.bookid = bookid;
        this.levelOptionInParent = levelOptionInParent;
        spelling = new JTextField(8);
        meaning = new JTextArea(8, 6);
        spelling.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        meaning.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        JScrollPane scrollpane = new JScrollPane(meaning);
        JLabel l1 = new JLabel("单词：");
        JLabel l2 = new JLabel("解释：");
        JLabel l3 = new JLabel("难度：");
        ok = new JButton("确认");
        cancel = new JButton("取消");
        ok.addActionListener(this);
        cancel.addActionListener(this);

        Box box = Box.createVerticalBox();
        box.add(Box.createVerticalStrut(10));
        box.add(l1);
        box.add(Box.createVerticalStrut(10));
        box.add(spelling);
        box.add(Box.createVerticalStrut(10));
        box.add(l3);
        box.add(Box.createVerticalStrut(10));
        box.add(inner);
        box.add(l2);
        box.add(Box.createVerticalStrut(10));
        box.add(scrollpane);
        box.add(Box.createVerticalStrut(10));
        Box boxx = Box.createHorizontalBox();
        boxx.add(ok);
        boxx.add(Box.createHorizontalStrut(30));
        boxx.add(cancel);
        box.add(boxx);
        box.add(Box.createVerticalStrut(10));

        Box boxOut = Box.createHorizontalBox();
        boxOut.add(Box.createHorizontalStrut(15));
        boxOut.add(box);
        boxOut.add(Box.createHorizontalStrut(15));

        add(boxOut);

        int pos = table.getSelectedRow();

        String spellingText = (String) tableModel.getValueAt(pos, 0);
        String meaningText = (String) tableModel.getValueAt(pos, 1);
        this.currentLevel = (String) tableModel.getValueAt(pos, 2);
        spelling.setText(spellingText);
        meaning.setText(meaningText);
        spelling.setEditable(false);//主键不能变 只能修改meaning
        inner.setSelectedItem(this.currentLevel);

        this.setModal(true);
        this.setSize(300, 300);
        this.setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
        this.setResizable(false);
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    private void editWord() {
        this.currentLevel = (String) inner.getSelectedItem();
        DbOperation db = new DbOperation();
        db.DbConnect();
        String sql = "select * from word where spelling='" + spelling.getText() + "' and bookid='" + bookid + "'";
        ResultSet rs = db.DBSqlQuery(sql);
        try {
            if (rs.next()) {
                rs.updateString(2, meaning.getText());
                rs.updateString(3, this.currentLevel);
                rs.updateRow();
            }
            if (this.levelOptionInParent.equals("全部难度")) {//如果已经选择了"全部难度" 那么这里就将修改的结果反映到当前视图
                tableModel.setValueAt(meaning.getText(), table.getSelectedRow(), 1);
                tableModel.setValueAt(this.currentLevel, table.getSelectedRow(), 2);
            } else if (this.levelOptionInParent.equals(this.currentLevel)) {//否则 如果和当前选择的难度相同 就显示
                tableModel.setValueAt(meaning.getText(), table.getSelectedRow(), 1);
            } else {//如果不同则从当前视图去除这条记录
                tableModel.removeRow(table.getSelectedRow());
            }//注意 这里影响的只是显示效果 与数据库的修改无关
        } catch (SQLException ex) {
            Logger.getLogger(EditWordDialog.class.getName()).log(Level.SEVERE, null, ex);
            JOptionPane.showConfirmDialog(this, "出现异常!", "修改失败", JOptionPane.CLOSED_OPTION, JOptionPane.ERROR_MESSAGE);
        }
        db.DbClose();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == ok) {
            if (meaningInputJudgement(meaning.getText())) {
                JOptionPane.showConfirmDialog(this, "解释不能为空!", "编辑失败", JOptionPane.CLOSED_OPTION, JOptionPane.ERROR_MESSAGE);
                meaning.setText(null);
                meaning.requestFocus();
            } else {
                editWord();
                dispose();
            }
        } else if (e.getSource() == cancel) {
            dispose();
        }
    }

    boolean meaningInputJudgement(String meaning) {
        Pattern p = Pattern.compile("\\s*+");//空白符出现一次或多次
        Matcher m = p.matcher(meaning);
        boolean b = m.matches();
        return b;
    }
}
