/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package vocabulary;

import method.DbOperation;
import method.DateCompute;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.*;
import java.awt.event.*;
import java.awt.*;
import java.sql.ResultSet;
import java.util.ArrayList;
import javax.swing.event.*;
import java.util.regex.*;
import java.sql.SQLException;
import java.text.DateFormat;
import java.util.Date;
import java.util.Calendar;
//import org.jvnet.substance.skin.*;

/**
 *
 * @author Administrator
 */
public class Main {

    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        // TODO code application logic here


        SwingUtilities.invokeLater(new Runnable() {

            public void run() {
                try {
                    JFrame.setDefaultLookAndFeelDecorated(true);
                    JDialog.setDefaultLookAndFeelDecorated(true);
                    UIManager.setLookAndFeel(new org.jvnet.substance.skin.SubstanceModerateLookAndFeel());
                } catch (Exception e) {
                    System.out.println("" + e);
                }

                MainFrame mfr = new MainFrame();
                mfr.setVisible(true);
            }
        });

        //MainFrame mfr = new MainFrame();
        //mfr.setVisible(true);


        /*  UIManager.LookAndFeelInfo[] looks = UIManager.getInstalledLookAndFeels();
        for (UIManager.LookAndFeelInfo look : looks) {
        System.out.println(look.getClassName());
        }*/


    }
}

class MainFrame extends JFrame {

    //JFrame fr = this;//因为其他窗口的创建都写在了匿名类里，所以所有JOptionPane窗口的第一个参数都是nullE而无法用this
    //所以add edit manage窗口的构造函数的第一个参数没法用this，因此这里才创建了这个JFrame fr=this
    //改成下句：
    MainFrame mfr = this;
    //再次重申：因为子窗口的构造函数都放在了匿名类里 所以无法使用this将父窗口传递到子窗口中 所以这里定义了MainFrame mfr=this
    //公共元素
    JButton btScan, btTest, btManage, btOption, btHelp, btSearch;
    JTextField searchField;
    JFrame searchFrame = new JFrame();
    JLabel Time = new JLabel();
    JComboBox changeSkin;
    Container con;
    JToolBar toolBar;
    JPanel rootpane;
    //"浏览"中的元素
    JButton add, edit, delete, save;
    JComboBox levelSelect, timeSelect;
    JButton showChart;
    JButton search;
    JTable wordList;
    JButton selectAll;
    JLabel statistics, currentBook;
    JButton changeBook;
    JTable table = null;
    MyTableModel tableModel = null;
    JPanel pCenterNeedUpdate = new JPanel();
    JPanel pSouthNeedUpdate = new JPanel();
    final String level[] = {"全部难度", "简单", "中等", "高级"};
    final String time[] = {"全部时间", "当天", "三天内", "一周内", "一月内"};
    String currentBookId = null;
    int justSelected[] = null;//记录刚才在table中所选择的记录的位置 一开始初始化为第一条的位置   
    //"测试"中的元素
    ButtonGroup bg_scale, bg_type, bg_sequence;
    JRadioButton scale_all, scale_selected;
    JRadioButton type_e2c, type_c2e, type_spell;
    JRadioButton seq_rand, seq_goeasy, seq_gohard;
    JTextField testNum;
    JButton startTest;
    ProgressBarThread progressBar;
    PaperThread paperThread;
    WaitDialog dlg;
    int countInrun = 0;
    int total;
    MakePaper makepaper;

    MainFrame() {
        setTitle("生词本");
        /******************/
        getCurrentBook();//首先获得当前生词本的名字,也就是修改了currentBookId        
        /******************/
        con = this.getContentPane();
        con.setLayout(new BorderLayout());
        rootpane = new JPanel();

        btScan = new JButton("浏览");
        btTest = new JButton("测试");
        btManage = new JButton("生词本管理");
        btOption = new JButton("设置");
        btHelp = new JButton("帮助");

        String skinList[] = {"SubstanceMistSilverLookAndFeel", "SubstanceNebulaBrickWallLookAndFeel", "SubstanceNebulaLookAndFeel", "SubstanceAutumnLookAndFeel", "SubstanceBusinessBlackSteelLookAndFeel", "SubstanceBusinessBlueSteelLookAndFeel", "SubstanceBusinessLookAndFeel", "SubstanceTwilightLookAndFeel", "SubstanceOfficeSilver2007LookAndFeel", "SubstanceOfficeBlue2007LookAndFeel", "SubstanceCremeLookAndFeel", "SubstanceModerateLookAndFeel", "SubstanceMistAquaLookAndFeel"};
        changeSkin = new JComboBox(skinList);
        changeSkin.setToolTipText("更换皮肤");
        changeSkin.setSelectedItem("SubstanceModerateLookAndFeel");
        changeSkin.addActionListener(new ActionListener() {

            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable() {

                    public void run() {
                        JFrame.setDefaultLookAndFeelDecorated(true);
                        JDialog.setDefaultLookAndFeelDecorated(true);
                        try {
                            String skinName = "org.jvnet.substance.skin." + (String) changeSkin.getSelectedItem();
                            UIManager.setLookAndFeel(skinName);
                            // mfr.setVisible(false);
                            //mfr.setVisible(true);
                            repaint();//重绘此组件 也可以把主窗口先隐藏再显示 只要让窗口重绘就行了
                        } catch (Exception e) {
                            System.out.println("" + e);
                        }
                    }
                });
            }
        });
        getTime();

        toolBar = new JToolBar();
        toolBar.setFloatable(false);
        toolBar.add(btScan);
        toolBar.add(btTest);
        toolBar.add(btManage);
        toolBar.add(btHelp);
        toolBar.add(Time);

        btScan.setToolTipText("查看当前生词本中的单词");
        btTest.setToolTipText("进行测验，检查学习效果");
        btManage.setToolTipText("管理已经创建的生词本");
        btOption.setToolTipText("设置");
        btHelp.setToolTipText("与作者联系");
        Time.setToolTipText("当前时间");

        con.add(toolBar, BorderLayout.NORTH);


        btScan.addActionListener(new ActionListener() {

            public void actionPerformed(ActionEvent e) {
                rootpane.removeAll();
                panelScan();
                validate();

            }
        });
        btTest.addActionListener(new ActionListener() {

            public void actionPerformed(ActionEvent e) {
                if (table != null) {
                    justSelected = table.getSelectedRows();//记录多行 可以是不连续的 如果一个都没选 那么返回的是空数组 就不再是null了
                }
                rootpane.removeAll();
                panelTest();
                validate();
            }
        });
        btManage.addActionListener(new ActionListener() {

            public void actionPerformed(ActionEvent e) {

                ManageDialog dlg = new ManageDialog(mfr);
            }
        });
        btHelp.addActionListener(new ActionListener() {

            public void actionPerformed(ActionEvent e) {
                HelpDialog dlg = new HelpDialog();
            }
        });


        add = new JButton("添加");
        add.setMnemonic('a');
        add.setToolTipText("添加新单词");
        add.addActionListener(new Add());
        edit = new JButton("编辑");
        edit.setToolTipText("编辑所选词条");
        edit.addActionListener(new Edit());
        delete = new JButton("删除");
        delete.setToolTipText("删除所选词条");
        delete.addActionListener(new Delete());
        save = new JButton("存为新生词本");
        save.setToolTipText("将所选词条添加到新的生词本中");
        save.addActionListener(new Save());

        levelSelect = new JComboBox(level);
        timeSelect = new JComboBox(time);
        levelSelect.setSelectedItem("全部难度");
        levelSelect.setToolTipText("按难度筛选词条");
        timeSelect.setSelectedItem("全部时间");
        timeSelect.setToolTipText("按时间范围筛选词条");
        levelSelect.addActionListener(new ActionListener() {

            public void actionPerformed(ActionEvent e) {
                int choiceLevel = levelSelect.getSelectedIndex();
                int choiceTime = timeSelect.getSelectedIndex();
                updateTable(level[choiceLevel], time[choiceTime]);
                setBottemWordCount();
            }
        });
        timeSelect.addActionListener(new ActionListener() {

            public void actionPerformed(ActionEvent e) {
                int choiceLevel = levelSelect.getSelectedIndex();
                int choiceTime = timeSelect.getSelectedIndex();
                updateTable(level[choiceLevel], time[choiceTime]);
                setBottemWordCount();
            }
        });
        showChart = new JButton("显示难度分布");
        showChart.setToolTipText("查看当前生词本的单词难度分布图");
        showChart.addActionListener(new ActionListener() {

            public void actionPerformed(ActionEvent e) {
                int easyCount = 0, mediumCount = 0, hardCount = 0;
                DbOperation db = new DbOperation();
                db.DbConnect();
                String sql = "select count(*) from word where level='" + "简单" + "' and bookid='" + currentBookId + "'";
                ResultSet rs = db.DBSqlQuery(sql);
                try {
                    if (rs.next()) {
                        easyCount = rs.getInt(1);
                    }
                } catch (SQLException ex) {
                    Logger.getLogger(MainFrame.class.getName()).log(Level.SEVERE, null, ex);
                }
                sql = "select count(*) from word where level='" + "中等" + "' and bookid='" + currentBookId + "'";
                rs = db.DBSqlQuery(sql);
                try {
                    if (rs.next()) {
                        mediumCount = rs.getInt(1);
                    }
                } catch (SQLException ex) {
                    Logger.getLogger(MainFrame.class.getName()).log(Level.SEVERE, null, ex);
                }
                sql = "select count(*) from word where level='" + "高级" + "' and bookid='" + currentBookId + "'";
                rs = db.DBSqlQuery(sql);
                try {
                    if (rs.next()) {
                        hardCount = rs.getInt(1);
                    }
                } catch (SQLException ex) {
                    Logger.getLogger(MainFrame.class.getName()).log(Level.SEVERE, null, ex);
                }
                db.DbClose();
                int sum = easyCount + mediumCount + hardCount;

                LevelChart.createPieChart(easyCount * 1.0 / sum, mediumCount * 1.0 / sum, hardCount * 1.0 / sum);

            }
        });

        search = new JButton("查找");
        search.setToolTipText("在当前生词本中查找某一单词");
        search.addActionListener(new ActionListener() {

            public void actionPerformed(ActionEvent e) {
                SearchDialog searchDlg = new SearchDialog(mfr);
            }
        });

        selectAll = new JButton("全选");
        selectAll.setToolTipText("选中当前视图下的所有词条");
        selectAll.addActionListener(new ActionListener() {

            public void actionPerformed(ActionEvent e) {
                table.setRowSelectionInterval(0, table.getRowCount() - 1);
            }
        });

        statistics = new JLabel();
        currentBook = new JLabel();
        changeBook = new JButton("更换生词本");
        changeBook.setToolTipText("打开生词本管理");
        changeBook.addActionListener(new ActionListener() {

            public void actionPerformed(ActionEvent e) {
                ManageDialog dlg = new ManageDialog(mfr);
            }
        });

        panelScan();//打开程序默认为"浏览"界面
        validate();

        setSize(800, 600);
        this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        this.setLocationRelativeTo(null);
    }

    void updateTable(String levelStr, String timeStr) {//-----------------需要更"智能"的语义分析
        //该函数用于将数据库中的查询而得到的数据返回到table中 用于"浏览"的初次显示 按难度查询和按时间查询
        //也就是panelScan()中对center部分的更新
        ArrayList temp = new ArrayList();
        DbOperation db = new DbOperation();
        db.DbConnect();
        String sql;
        if (levelStr.equals("全部难度") && timeStr.equals("全部时间")) {// 表明查询所有记录
            sql = "SELECT * FROM word where bookid='" + this.currentBookId + "'";
            ResultSet rs = db.DBSqlQuery(sql);
            try {
                while (rs.next()) {
                    temp.add(rs.getString(1));
                    temp.add(rs.getString(2));
                    temp.add(rs.getString(3));
                    temp.add(rs.getString(4));
                }
            } catch (SQLException ex) {
                Logger.getLogger(MainFrame.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else if (levelStr.equals("全部难度")) {
            sql = "select * from word where bookid='" + this.currentBookId + "'";
            ResultSet rs = db.DBSqlQuery(sql);
            int timePos = this.timeSelect.getSelectedIndex();
            try {
                while (rs.next()) {
                    String spellingh = rs.getString(1);
                    String meaningh = rs.getString(2);
                    String levelh = rs.getString(3);
                    String timeh = rs.getString(4);
                    String timeArray[] = timeh.split("\\.");
                    Calendar timeGot = Calendar.getInstance();
                    timeGot.set(Calendar.YEAR, Integer.valueOf(timeArray[0]));
                    timeGot.set(Calendar.MONTH, Integer.valueOf(timeArray[1]) - 1);
                    timeGot.set(Calendar.DATE, Integer.valueOf(timeArray[2]));
                    Calendar timeCurrent = DateCompute.getCurrentDateObject();
                    boolean ok = false;
                    switch (timePos) {
                        case 1://当天
                            if (Integer.valueOf(timeArray[0]) == timeCurrent.get(Calendar.YEAR) && Integer.valueOf(timeArray[1]) == timeCurrent.get(Calendar.MONTH) + 1 && Integer.valueOf(timeArray[2]) == timeCurrent.get(Calendar.DATE)) {
                                ok = true;
                            }
                            break;
                        case 2://三天
                            timeCurrent.add(Calendar.DATE, -3);
                            if (timeGot.after(timeCurrent)) {
                                ok = true;
                            }
                            break;
                        case 3:
                            timeCurrent.add(Calendar.DATE, -7);
                            if (timeGot.after(timeCurrent)) {
                                ok = true;
                            }
                            break;
                        case 4:
                            timeCurrent.add(Calendar.MONTH, -1);
                            if (timeGot.after(timeCurrent)) {
                                ok = true;
                            }
                            break;
                    }
                    if (ok) {
                        temp.add(spellingh);
                        temp.add(meaningh);
                        temp.add(levelh);
                        temp.add(timeh);
                    }
                }
            } catch (SQLException ex) {
                Logger.getLogger(MainFrame.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else if (timeStr.equals("全部时间")) {
            sql = "select * from word where level='" + levelStr + "' and bookid='" + this.currentBookId + "'";
            ResultSet rs = db.DBSqlQuery(sql);
            try {
                while (rs.next()) {
                    temp.add(rs.getString(1));
                    temp.add(rs.getString(2));
                    temp.add(rs.getString(3));
                    temp.add(rs.getString(4));
                }
            } catch (SQLException ex) {
                Logger.getLogger(MainFrame.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            sql = "select * from word where level='" + levelStr + "' and bookid='" + this.currentBookId + "'";
            ResultSet rs = db.DBSqlQuery(sql);
            int timePos = this.timeSelect.getSelectedIndex();
            try {
                while (rs.next()) {
                    String spellingh = rs.getString(1);
                    String meaningh = rs.getString(2);
                    String levelh = rs.getString(3);
                    String timeh = rs.getString(4);
                    String timeArray[] = timeh.split("\\.");
                    Calendar timeGot = Calendar.getInstance();
                    timeGot.set(Calendar.YEAR, Integer.valueOf(timeArray[0]));
                    timeGot.set(Calendar.MONTH, Integer.valueOf(timeArray[1]) - 1);
                    timeGot.set(Calendar.DATE, Integer.valueOf(timeArray[2]));
                    Calendar timeCurrent = DateCompute.getCurrentDateObject();
                    boolean ok = false;
                    switch (timePos) {
                        case 1://当天
                            if (Integer.valueOf(timeArray[0]) == timeCurrent.get(Calendar.YEAR) && Integer.valueOf(timeArray[1]) == timeCurrent.get(Calendar.MONTH) + 1 && Integer.valueOf(timeArray[2]) == timeCurrent.get(Calendar.DATE)) {
                                ok = true;
                            }
                            break;
                        case 2://三天
                            timeCurrent.add(Calendar.DATE, -3);
                            if (timeGot.after(timeCurrent)) {
                                ok = true;
                            }
                            break;
                        case 3:
                            timeCurrent.add(Calendar.DATE, -7);
                            if (timeGot.after(timeCurrent)) {
                                ok = true;
                            }
                            break;
                        case 4:
                            timeCurrent.add(Calendar.MONTH, -1);
                            if (timeGot.after(timeCurrent)) {
                                ok = true;
                            }
                            break;
                    }
                    if (ok) {
                        temp.add(spellingh);
                        temp.add(meaningh);
                        temp.add(levelh);
                        temp.add(timeh);
                    }
                }
            } catch (SQLException ex) {
                Logger.getLogger(MainFrame.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        db.DbClose();
        int length = temp.size();
        if (length == 0) {//这里需要修改--------------------------------
            edit.setEnabled(false);
            delete.setEnabled(false);
            save.setEnabled(false);
            if (table == null) {//如果打开程序时数据库为空，则在updateTable中并没有初始化table，需要将这个工作放在这里
                Object data[][] = null;
                String colName[] = {"单词", "解释", "难度", "添加时间"};
                tableModel = new MyTableModel(data, colName);
                table = new JTable(tableModel);
                ListSelectionModel listselect = table.getSelectionModel();//选择table中的某一列时使edit save delete按钮被激活
                listselect.addListSelectionListener(new ListSelectionListener() {

                    public void valueChanged(ListSelectionEvent e) {
                        focusChanged();
                    }
                });
                setTableProperties();
            }
            tableModel.setRowCount(0);//以供按难度和按时间查询时能正常在底部显示单词个数
            table.setModel(tableModel);
            tableModel.scrollpane = new JScrollPane(table);
            pCenterNeedUpdate.removeAll();
            pCenterNeedUpdate.add(tableModel.scrollpane);
            pCenterNeedUpdate.validate();
        } else {
            Object data[][] = new Object[length / 4][4];
            int i;
            for (i = 0; i < length; i++) {
                data[i / 4][i % 4] = temp.get(i);
            }
            String colName[] = {"单词", "解释", "难度", "添加时间"};
            /***************************/
            tableModel = new MyTableModel(data, colName);
            table = new JTable(tableModel);

            ListSelectionModel listselect = table.getSelectionModel();//选择table中的某一列时使edit save delete按钮被激活
            listselect.addListSelectionListener(new ListSelectionListener() {

                public void valueChanged(ListSelectionEvent e) {

                    focusChanged();

                }
            });

            setTableProperties();

            if (this.justSelected != null && this.justSelected.length > 0) {//记忆不连续区域
                table.setRowSelectionInterval(justSelected[0], justSelected[0]);//注意不要让数组越界
                for (int r = 1; r < justSelected.length; r++) {
                    int pos = justSelected[r];
                    table.getSelectionModel().addSelectionInterval(pos, pos);//对选择区域去并集
                }
            }

            /***************************/
            tableModel.scrollpane = new JScrollPane(table);
            pCenterNeedUpdate.removeAll();
            pCenterNeedUpdate.add(tableModel.scrollpane);
            pCenterNeedUpdate.validate();
        }
    }

    void panelScan() {
        rootpane.setLayout(new BorderLayout());//更新north
        JPanel pNorth = new JPanel();
        Box box = Box.createHorizontalBox();
        box.add(add);
        box.add(Box.createHorizontalStrut(15));
        box.add(edit);
        box.add(Box.createHorizontalStrut(15));
        box.add(delete);
        box.add(Box.createHorizontalStrut(15));
        box.add(save);
        box.add(Box.createHorizontalStrut(45));
        box.add(levelSelect);
        box.add(Box.createHorizontalStrut(15));
        box.add(timeSelect);
        box.add(Box.createHorizontalStrut(15));
        box.add(showChart);
        box.add(Box.createHorizontalStrut(15));
        box.add(search);
        pNorth.add(box);
        rootpane.add(pNorth, BorderLayout.NORTH);

        int choiceLevel = levelSelect.getSelectedIndex();
        int choiceTime = timeSelect.getSelectedIndex();
        /******************/
        updateTable(level[choiceLevel], time[choiceTime]);//更新center

        pSouthNeedUpdate.removeAll();


        if (table != null) {//下面更新south
            String labelText = "共计:" + Integer.toString(table.getRowCount()) + "个单词";
            statistics.setText(labelText);
        }
        currentBook.setText("当前是" + this.currentBookId);

        Box boxx = Box.createHorizontalBox();
        boxx.add(selectAll);
        boxx.add(Box.createHorizontalStrut(8));
        boxx.add(statistics);
        boxx.add(Box.createHorizontalStrut(8));
        boxx.add(currentBook);
        boxx.add(Box.createHorizontalStrut(8));
        boxx.add(changeBook);
        boxx.add(Box.createHorizontalStrut(8));
        boxx.add(this.changeSkin);
        pSouthNeedUpdate.add(boxx);
        pSouthNeedUpdate.validate();
        /******************/
        rootpane.add(pCenterNeedUpdate, BorderLayout.CENTER);
        rootpane.add(pSouthNeedUpdate, BorderLayout.SOUTH);

        con.add(rootpane, BorderLayout.CENTER);
    }

    void panelTest() {
        int wordCount = table.getRowCount();//获取当前table中的单词数
        int selectRows[] = table.getSelectedRows();
        int selectCount = selectRows.length;

        this.bg_scale = new ButtonGroup();
        this.scale_all = new JRadioButton("全部单词(" + wordCount + ")");
        this.scale_selected = new JRadioButton("选中的单词(" + selectCount + ")");
        scale_selected.setEnabled(selectCount > 0);
        scale_all.setActionCommand("all");
        scale_selected.setActionCommand("selected");
        bg_scale.add(scale_all);
        bg_scale.add(scale_selected);
        bg_scale.setSelected(scale_all.getModel(), true);

        this.bg_type = new ButtonGroup();
        this.type_c2e = new JRadioButton("汉英选择题");
        this.type_e2c = new JRadioButton("英汉选择题");
        this.type_spell = new JRadioButton("单词拼写");
        this.type_c2e.setActionCommand("c2e");
        this.type_e2c.setActionCommand("e2c");
        this.type_spell.setActionCommand("spell");
        bg_type.add(this.type_c2e);
        bg_type.add(this.type_e2c);
        bg_type.add(this.type_spell);
        bg_type.setSelected(type_c2e.getModel(), true);

        this.bg_sequence = new ButtonGroup();
        this.seq_goeasy = new JRadioButton("从难到易");
        this.seq_gohard = new JRadioButton("从易到难");
        this.seq_rand = new JRadioButton("随机顺序");
        this.seq_goeasy.setActionCommand("goeasy");
        this.seq_gohard.setActionCommand("gohard");
        this.seq_rand.setActionCommand("rand");
        this.bg_sequence.add(seq_goeasy);
        this.bg_sequence.add(seq_gohard);
        this.bg_sequence.add(seq_rand);
        bg_sequence.setSelected(seq_goeasy.getModel(), true);

        JPanel scale = new JPanel();
        JPanel type = new JPanel();
        JPanel seq = new JPanel();

        Box box = Box.createVerticalBox();
        box.add(new JLabel("范围"));
        box.add(Box.createVerticalStrut(15));
        box.add(this.scale_all);
        box.add(Box.createVerticalStrut(15));
        box.add(this.scale_selected);
        scale.add(box);

        box = Box.createVerticalBox();
        box.add(new JLabel("题型"));
        box.add(Box.createVerticalStrut(15));
        box.add(this.type_c2e);
        box.add(Box.createVerticalStrut(15));
        box.add(this.type_e2c);
        box.add(Box.createVerticalStrut(15));
        box.add(this.type_spell);
        type.add(box);

        box = Box.createVerticalBox();
        box.add(new JLabel("顺序"));
        box.add(Box.createVerticalStrut(15));
        box.add(this.seq_goeasy);
        box.add(Box.createVerticalStrut(15));
        box.add(this.seq_gohard);
        box.add(Box.createVerticalStrut(15));
        box.add(this.seq_rand);
        seq.add(box);

        JPanel pCenter = new JPanel();
        FlowLayout layout = new FlowLayout();
        layout.setHgap(80);
        pCenter.setLayout(layout);
        pCenter.add(scale);
        pCenter.add(type);
        pCenter.add(seq);

        JPanel pSouth = new JPanel();
        testNum = new JTextField(15);
        testNum.setText("20");
        testNum.setToolTipText("输入完成后按两次回车键自动进入测试");
        testNum.addActionListener(new ActionListener() {

            public void actionPerformed(ActionEvent e) {
                startTest.requestFocus();//输入完毕 回车一次 开始按钮获得焦点
            }
        });
        startTest = new JButton("开始");
        startTest.addActionListener(new StartTest());
        box = Box.createHorizontalBox();
        box.add(new JLabel("试题数"));
        box.add(Box.createHorizontalStrut(10));
        box.add(testNum);
        box.add(Box.createHorizontalStrut(50));
        box.add(startTest);
        pSouth.add(box);

        rootpane.setLayout(new BorderLayout());
        rootpane.add(pCenter, BorderLayout.CENTER);
        rootpane.add(pSouth, BorderLayout.SOUTH);

        con.add(rootpane, BorderLayout.CENTER);
    }

    synchronized void reborn() {
        notifyAll();
    }

    synchronized void holdUp() throws InterruptedException {
        wait();
    }

    void setTableProperties() {
        table.setAutoResizeMode(JTable.AUTO_RESIZE_ALL_COLUMNS);
        table.setGridColor(Color.BLUE);
        table.setSelectionMode(ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
        //table.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);//设置为单行模式
        table.setSelectionBackground(Color.RED);
        table.setSelectionForeground(Color.WHITE);
        table.setBorder(BorderFactory.createLoweredBevelBorder());
        table.getTableHeader().setReorderingAllowed(false);//禁止移动列
    }

    void deleteDbItem(String key) {//删除时注意主键

        DbOperation db = new DbOperation();
        db.DbConnect();
        String sql = "delete * from word where spelling='" + key + "' and  bookid='" + this.currentBookId + "'";
        db.DbSqlUpdate(sql);
        db.DbClose();

    }

    void focusChanged() {
        edit.setEnabled(table.getSelectedRow() != -1);
        save.setEnabled(table.getSelectedRow() != -1);
        delete.setEnabled(table.getSelectedRow() != -1);
    }

    void getCurrentBook() {
        DbOperation db = new DbOperation();
        db.DbConnect();
        String sql = "select name from book where type='" + "1" + "'";
        ResultSet rs = db.DBSqlQuery(sql);
        try {
            if (rs.next()) {
                this.currentBookId = rs.getString(1);
            }
        } catch (SQLException ex) {
            Logger.getLogger(MainFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        db.DbClose();
    }

    void setBottemWordCount() {
        String labelText = "共计:" + Integer.toString(tableModel.getRowCount()) + "个单词";
        statistics.setText(labelText);
        statistics.updateUI();
    }

    boolean addNewBook(String name, String type) {
        boolean ok = true;
        DbOperation db = new DbOperation();
        db.DbConnect();
        String sql = "insert into book values('" + name + "','" + type + "')";
        ok = db.DbSqlUpdate(sql);
        if (ok == false) {
            JOptionPane.showConfirmDialog(null, "名字重复或为非法字符", "添加失败", JOptionPane.CLOSED_OPTION, JOptionPane.WARNING_MESSAGE);
        }
        db.DbClose();
        return ok;//发生异常返回false 正常结束返回true
    }

    void addItemToDb(String spelling, String meaning, String level, String time, String bookid) {
        DbOperation db = new DbOperation();
        db.DbConnect();
        String sql = "insert into word values('" + spelling + "','" + meaning + "','" + level + "','" + time + "','" + bookid + "')";
        db.DbSqlUpdate(sql);
        db.DbClose();
    }

    int getWordCount(String bookid) {
        int count = 0;
        DbOperation db = new DbOperation();
        db.DbConnect();
        String sql = "select count(*) from word where bookid='" + bookid + "'";
        ResultSet rs = db.DBSqlQuery(sql);
        try {
            if (rs.next()) {
                count = rs.getInt(1);
            }
        } catch (SQLException ex) {
            Logger.getLogger(MainFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        db.DbClose();
        return count;
    }

    boolean testNumJudgement(String num) {
        Pattern p = Pattern.compile("[0-9]{1,2}+");//由数字组成 最少一位 最多两位
        Matcher m = p.matcher(num);
        boolean b = m.matches();
        return b;
    }

    boolean bookidInputJudgement(String bookid) {
        Pattern p = Pattern.compile("\\s*+");//空白符出现一次或多次
        Matcher m = p.matcher(bookid);
        boolean b = m.matches();
        return b;
    }

    void getTime() {
        Date date = new Date();
        DateFormat shortFormat = DateFormat.getDateTimeInstance(DateFormat.SHORT, DateFormat.SHORT);
        Time.setText(shortFormat.format(date));
    }

    private class ProgressBarThread extends Thread {

        @Override
        public void run() {
            makepaper = PaperFactory.CreateMakePaper(bg_type.getSelection().getActionCommand());//根据题目类型建造产品makepaper
            makepaper.setContent(bg_scale, table, tableModel);//生成测试总体
            makepaper.initNumberList();//初始化随机数索引序列
            makepaper.setCurrentBookId(currentBookId);//获取当前生词本名
            makepaper.setTestNum(testNum);//获取题目数量

            SwingUtilities.invokeLater(new Runnable() {

                public void run() {
                    dlg = new WaitDialog();
                    dlg.setLocationRelativeTo(null);
                    total = makepaper.getTestNum();
                    dlg.adoptDeterminate(total);
                    paperThread = new PaperThread();
                    paperThread.start();
                }
            });
            return;
        }
    }

    private class PaperThread extends Thread {

        @Override
        public void run() {
            for (int i = 0; i < total; i++) {//生成题目
                makepaper.addOneSub();
                countInrun = i;
                SwingUtilities.invokeLater(new Runnable() {//将对象排到事件派发线程的队列中 只有从事件派发线程才能更新组件

                    public void run() {//实例化更新组件的线程
                        dlg.setValue(countInrun);
                    }
                });
            }
            SwingUtilities.invokeLater(new Runnable() {//将对象排到事件派发线程的队列中 只有从事件派发线程才能更新组件

                public void run() {//实例化更新组件的线程
                    dlg.finishDeterminate();
                    TestFrame testframe = new TestFrame(mfr, makepaper.getDataHead(), makepaper.getDataBody(), makepaper.getRightPos());
                    testframe.setVisible(true);
                }
            });
            return;
        }
    }

    private class Add implements ActionListener {

        public void actionPerformed(ActionEvent e) {
            AddWordDialog dlg = new AddWordDialog(mfr, table, tableModel, currentBookId, (String) levelSelect.getSelectedItem());
            setBottemWordCount();
        }
    }

    private class Edit implements ActionListener {

        public void actionPerformed(ActionEvent e) {
            if (table.getSelectedRow() == -1) {
                JOptionPane.showConfirmDialog(null, "没有选中任何单词", "编辑失败", JOptionPane.CLOSED_OPTION, JOptionPane.WARNING_MESSAGE);
            } else if (table.getSelectedRows().length > 1) {
                JOptionPane.showConfirmDialog(null, "请选中一个单词", "编辑失败", JOptionPane.CLOSED_OPTION, JOptionPane.WARNING_MESSAGE);
            } else {
                EditWordDialog dlg = new EditWordDialog(mfr, table, tableModel, currentBookId, (String) levelSelect.getSelectedItem());
                setBottemWordCount();//编辑结束后由于level的问题 记录条数可能也会发生改变
            }
        }
    }

    private class Delete implements ActionListener {

        public void actionPerformed(ActionEvent e) {
            if (table.getSelectedRow() == -1) {
                JOptionPane.showConfirmDialog(null, "没有选中任何单词", "删除失败", JOptionPane.CLOSED_OPTION, JOptionPane.WARNING_MESSAGE);
            } else {
                int choice = JOptionPane.showConfirmDialog(null, "确定要删除所选单词吗？", "注意", JOptionPane.OK_CANCEL_OPTION, JOptionPane.WARNING_MESSAGE);
                if (choice == JOptionPane.OK_OPTION) {
                    int posArray[] = table.getSelectedRows();
                    int i, j;
                    int n = posArray.length;
                    for (i = 0; i < n; i++) {

                        String key = (String) tableModel.getValueAt(posArray[i], 0);//获得当前所选记录的主键  注意下标从0开始
                        deleteDbItem(key);//从数据库中删除具有此主键的记录
                        tableModel.removeRow(posArray[i]);//同时更新table*/
                        for (j = i; j < n; j++) {
                            posArray[j]--;//注意，后面的行值要递减
                            }
                    }
                    setBottemWordCount();
                }
            }
        }
    }

    private class Save implements ActionListener {

        public void actionPerformed(ActionEvent e) {
            int selectRows[] = table.getSelectedRows();
            if (selectRows.length == 0) {
                JOptionPane.showConfirmDialog(null, "没有选择任何一个单词", "另存失败", JOptionPane.CLOSED_OPTION, JOptionPane.WARNING_MESSAGE);
            } else {
                int i;
                String spelling, meaning, level, time, newBookName = null;
                newBookName = JOptionPane.showInputDialog(null, "新生词本的名字是：", "存为新生词本", JOptionPane.QUESTION_MESSAGE);
                if (newBookName != null && newBookName.length() > 0 && newBookName.length() <= 10 && bookidInputJudgement(newBookName) == false) {
                    boolean ok = addNewBook(newBookName, "0");
                    if (ok) {
                        for (i = 0; i < selectRows.length; i++) {
                            spelling = (String) tableModel.getValueAt(selectRows[i], 0);
                            meaning = (String) tableModel.getValueAt(selectRows[i], 1);
                            level = (String) tableModel.getValueAt(selectRows[i], 2);
                            time = (String) tableModel.getValueAt(selectRows[i], 3);
                            addItemToDb(spelling, meaning, level, time, newBookName);
                        }
                        JOptionPane.showConfirmDialog(null, "添加成功", "提示", JOptionPane.CLOSED_OPTION, JOptionPane.INFORMATION_MESSAGE);
                    }
                } else if (newBookName != null && (newBookName.length() == 0 || bookidInputJudgement(newBookName))) {
                    JOptionPane.showConfirmDialog(null, "名字不能为空", "另存失败", JOptionPane.CLOSED_OPTION, JOptionPane.WARNING_MESSAGE);
                } else if (newBookName != null && newBookName.length() > 10) {
                    JOptionPane.showConfirmDialog(null, "名字的长度不能超过10个字符", "另存失败", JOptionPane.CLOSED_OPTION, JOptionPane.WARNING_MESSAGE);
                }
            }
        }
    }

    private class StartTest implements ActionListener {

        public void actionPerformed(ActionEvent e) {//如果所有单选按钮已选且文本域中是在某一范围内的正整数
            if (getWordCount(currentBookId) < 5) {
                JOptionPane.showConfirmDialog(null, "当前生词本的单词太少，无法生成试题", "注意", JOptionPane.CLOSED_OPTION, JOptionPane.ERROR_MESSAGE);
            } else if (testNumJudgement(testNum.getText()) == false || Integer.valueOf(testNum.getText()) == 0) {//加上对输入内容的判断
                JOptionPane.showConfirmDialog(null, "请输入一个1-99的整数", "注意", JOptionPane.CLOSED_OPTION, JOptionPane.ERROR_MESSAGE);
                testNum.setText(null);
                testNum.requestFocus();
            } else {
                startTest.setEnabled(false);//防止瞬间多次点击出现多个窗口
                mfr.setVisible(false);//mfr.dispose();也行
                progressBar = new ProgressBarThread();//从Reportdialog回到这里用的是setvisible 没有重新创建该窗口即没有执行构造函数 因为前面的线程已经死了 所以在这里要重新创建 通过分析工具既可以看到线程的状态
                progressBar.start();
            }
        }
    }
}

class PaperFactory {

    public static MakePaper CreateMakePaper(String type) {//依赖于抽象而不依赖于具体 所谓DIP 依赖倒转原则 用抽象类或者接口作为类型声明 出现父类的地方用子类代替 所谓多态性的体现
        if (type.equals("e2c")) {
            return new SelectEtoC();
        } else if (type.equals("c2e")) {
            return new SelectCtoE();
        } else {
            return new Spelling();
        }
    }
}

abstract class MakePaper {

    ArrayList<Integer> numberList = new ArrayList<Integer>();
    ArrayList<String> dataHead = new ArrayList<String>();//记录问题
    ArrayList<String[]> dataBody = new ArrayList<String[]>();//记录答案
    ArrayList<Integer> rightPos = new ArrayList<Integer>();//记录正确答案的位置
    ArrayList<ArrayList<String>> content = new ArrayList<ArrayList<String>>();//测试的总体 包含的是一个个单词条目
    String currentBookId;
    int nTest;

    MakePaper() {
    }

    abstract void addOneSub();//添加一道题目 该方法需要子类实现

    ArrayList<String> getDataHead() {
        return this.dataHead;
    }

    ArrayList<String[]> getDataBody() {
        return this.dataBody;
    }

    ArrayList<Integer> getRightPos() {
        return this.rightPos;
    }

    void initNumberList() {//初始化随机数索引列表
        for (int i = 0; i < content.size(); i++) {
            numberList.add(i);//初始化一列数 从0到content.size()-1
            }
    }

    void setCurrentBookId(String str) {//获得当前生词本的名字
        this.currentBookId = str;
    }

    void setContent(ButtonGroup bg, JTable table, MyTableModel tableModel) {//获得测试总体
        if (bg.getSelection().getActionCommand().equals("all")) {//全部单词 指table上的
            for (int i = 0; i < table.getRowCount(); i++) {
                ArrayList<String> record = new ArrayList<String>();//一个单词条目 包括spelling meaning level
                for (int j = 0; j < 3; j++) {
                    record.add((String) tableModel.getValueAt(i, j));
                }
                content.add(record);
            }
        } else {//所选单词 仅从table上获取即可
            for (int i = 0; i < table.getSelectedRows().length; i++) {
                ArrayList<String> record = new ArrayList<String>();
                for (int j = 0; j < 3; j++) {
                    record.add((String) tableModel.getValueAt(table.getSelectedRows()[i], j));
                }
                content.add(record);
            }
        }
    }

    void setTestNum(JTextField testNum) {//获得测试的题目数量
        nTest = content.size() < Integer.valueOf(testNum.getText()) ? content.size() : Integer.valueOf(testNum.getText());
    }

    int getTestNum() {
        return nTest;
    }

    int getRandNum() {
        return (int) (Math.random() * numberList.size());
    }
}

class SelectEtoC extends MakePaper {

    SelectEtoC() {
    }

    void addOneSub() {
        int s = getRandNum();
        int choice = numberList.get(s);
        String head = content.get(choice).get(0);//问题（*）
        int right = (int) (Math.random() * 4);//随机正确答案的位置
        rightPos.add(right);
        String body[] = new String[4];
        body[right] = content.get(choice).get(1);//正确答案（*）
        ArrayList<String> wrong = generateWrongAnswers(content.get(choice).get(1));//产生错误答案
        int k = 0;
        for (int j = 0; j < 4; j++) {//填充错误答案
            if (j != right) {
                body[j] = wrong.get(k);//错误答案（*）
                k++;
            }
        }
        dataHead.add(head);
        dataBody.add(body);
        numberList.remove(s);
    }

    ArrayList<String> generateWrongAnswers(String rightAnswer) {//错误答案的产生总体不应只是测试总体 应该是这个生词本
        ArrayList<String> wrong = new ArrayList<String>();//记录产生的错误答案
        ArrayList<String> wrongScale = new ArrayList<String>();//错误答案的产生总体
        DbOperation db = new DbOperation();
        db.DbConnect();
        db.setPreStme("select meaning from word where bookid=?");
        try {
            db.prestmt.setString(1, currentBookId); //英译汉
            ResultSet rs = db.prestmt.executeQuery();
            while (rs.next()) {
                wrongScale.add(rs.getString(1));
            }
        } catch (SQLException ex) {
            Logger.getLogger(TestFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        db.DbClose();
        int k = 0;
        int i;
        int wordCount = wrongScale.size();
        while (k < 3) {//要产生三个结果 所以如果生词本的单词个数小于4 则无法形成试题
            i = (int) (Math.random() * wordCount);

            String preWrong = wrongScale.get(i);
            if (preWrong.equals(rightAnswer) == false && wrong.contains(preWrong) == false) {//如果是错误答案而且并未记录
                wrong.add(preWrong);
                k++;
            }
        }
        return wrong;
    }
}

class SelectCtoE extends MakePaper {

    SelectCtoE() {
    }

    void addOneSub() {
        int s = getRandNum();
        int choice = numberList.get(s);
        String head = content.get(choice).get(1);//问题（*）
        int right = (int) (Math.random() * 4);//随机正确答案的位置
        rightPos.add(right);
        String body[] = new String[4];
        body[right] = content.get(choice).get(0);//正确答案（*）
        ArrayList<String> wrong = generateWrongAnswers(content.get(choice).get(0));//产生错误答案
        int k = 0;
        for (int j = 0; j < 4; j++) {//填充错误答案
            if (j != right) {
                body[j] = wrong.get(k);//错误答案（*）
                k++;
            }
        }
        dataHead.add(head);
        dataBody.add(body);
        numberList.remove(s);
    }

    ArrayList<String> generateWrongAnswers(String rightAnswer) {//错误答案的产生总体不应只是测试总体 应该是这个生词本
        ArrayList<String> wrong = new ArrayList<String>();//记录产生的错误答案
        ArrayList<String> wrongScale = new ArrayList<String>();//错误答案的产生总体
        DbOperation db = new DbOperation();
        db.DbConnect();
        db.setPreStme("select spelling from word where bookid=?");
        try {
            db.prestmt.setString(1, currentBookId);
            ResultSet rs = db.prestmt.executeQuery();
            while (rs.next()) {
                wrongScale.add(rs.getString(1));
            }
        } catch (SQLException ex) {
            Logger.getLogger(TestFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        db.DbClose();
        int k = 0;
        int i;
        int wordCount = wrongScale.size();
        while (k < 3) {//要产生三个结果 所以如果生词本的单词个数小于4 则无法形成试题
            i = (int) (Math.random() * wordCount);

            String preWrong = wrongScale.get(i);
            if (preWrong.equals(rightAnswer) == false && wrong.contains(preWrong) == false) {//如果是错误答案而且并未记录
                wrong.add(preWrong);
                k++;
            }
        }
        return wrong;
    }
}

class Spelling extends MakePaper {

    Spelling() {
    }

    void addOneSub() {//到时候通过循环添加多道题
        int s = getRandNum();
        int choice = numberList.get(s);
        String head = content.get(choice).get(1);//汉语解释作为题目
        String body[] = new String[1];
        body[0] = content.get(choice).get(0);//英语单词作为答案
        dataHead.add(head);
        dataBody.add(body);//拼写题中 由dataBody记录正确答案
        numberList.remove(s);//remove的是index
        }
}

