/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * ShowResultDialog.java
 *
 * Created on 2009-11-22, 16:15:12
 */
package vocabulary;

/**
 *
 * @author Administrator
 */
public class ShowResultDialog extends javax.swing.JDialog {

    TestData testdata;
    MyTableModel tableModel;
    String testType;//"spelling"----拼写题 "mutual"----英译汉和汉译英

    /** Creates new form ShowResultDialog */
    public ShowResultDialog(TestData testdata) {
        this.testdata = testdata;
        if (testdata.selectPos.size() == 0) {//因为拼写题的答案没有写在selectPos里
            testType = "spelling";
        } else {
            testType = "mutual";
        }
        String colName[] = {"题号", "题目", "你的答案", "结果", "正确答案"};

        tableModel = new MyTableModel(generateTableContent(), colName);

        initComponents();
        String str = "本次测试共" + testdata.dataHead.size() + "道题：  " + testdata.rightNum + "道正确  " + testdata.wrongNum + "道错误  " + testdata.skipNum + "道未答";
        resultText.setText(str);
        double mark = testdata.rightNum * 100.0 / testdata.dataHead.size();
        score.setText("得分：  " + mark);
        this.setTitle("测试结果");
        this.setModal(false);//这里改成无模态是为了不让ReportDialog中的进度条线程处在等待状态
        this.setResizable(false);
        this.setLocationRelativeTo(null);
        setDefaultCloseOperation(DO_NOTHING_ON_CLOSE);
        setVisible(true);
    }

    Object[][] generateTableContent() {//"题号", "题目", "你的答案", "结果", "正确答案"
        int rowCount = testdata.dataHead.size();
        Object data[][] = new Object[rowCount][5];
        for (int i = 0; i < rowCount; i++) {
            data[i][0] = i + 1;
            data[i][1] = testdata.dataHead.get(i);
            if (testType.equals("spelling")) {
                data[i][2] = testdata.spellingAnswers.get(i);
            } else {
                if (testdata.selectPos.get(i) != -1) {
                    data[i][2] = testdata.dataBody.get(i)[testdata.selectPos.get(i)];
                } else {
                    data[i][2] = "未答";
                }
            }
            if (testdata.result.get(i).equals("r")) {
                data[i][3] = "正确";
            } else if (testdata.result.get(i).equals("w")) {
                data[i][3] = "错误";
            } else {
                data[i][3] = "NOP";
            }
            if (testType.equals("spelling")) {
                data[i][4] = testdata.dataBody.get(i)[0];
            } else {
                data[i][4] = testdata.dataBody.get(i)[testdata.rightPos.get(i)];
            }
        }
        return data;
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jScrollPane1 = new javax.swing.JScrollPane();
        jTable1 = new javax.swing.JTable();
        jSeparator1 = new javax.swing.JSeparator();
        resultText = new javax.swing.JLabel();
        jButtonOK = new javax.swing.JButton();
        jButtonAgain = new javax.swing.JButton();
        score = new javax.swing.JLabel();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);

        jTable1.setModel(tableModel);
        jScrollPane1.setViewportView(jTable1);

        resultText.setText("jLabel1");

        jButtonOK.setText("确定");
        jButtonOK.requestFocus();
        jButtonOK.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonOKActionPerformed(evt);
            }
        });

        jButtonAgain.setText("再答一遍");
        jButtonAgain.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonAgainActionPerformed(evt);
            }
        });

        score.setText("jLabel1");

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 841, Short.MAX_VALUE)
            .addComponent(jSeparator1, javax.swing.GroupLayout.DEFAULT_SIZE, 841, Short.MAX_VALUE)
            .addGroup(layout.createSequentialGroup()
                .addGap(252, 252, 252)
                .addComponent(jButtonOK)
                .addGap(196, 196, 196)
                .addComponent(jButtonAgain)
                .addContainerGap(255, Short.MAX_VALUE))
            .addGroup(layout.createSequentialGroup()
                .addGap(94, 94, 94)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(score)
                    .addComponent(resultText))
                .addContainerGap(705, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addComponent(jScrollPane1, javax.swing.GroupLayout.PREFERRED_SIZE, 251, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jSeparator1, javax.swing.GroupLayout.PREFERRED_SIZE, 10, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(27, 27, 27)
                .addComponent(resultText)
                .addGap(26, 26, 26)
                .addComponent(score)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 46, Short.MAX_VALUE)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jButtonOK)
                    .addComponent(jButtonAgain))
                .addGap(82, 82, 82))
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void jButtonAgainActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonAgainActionPerformed
        // TODO add your handling code here:
        TestFrame testframe = new TestFrame(testdata.mfr, testdata.dataHead, testdata.dataBody, testdata.rightPos);
        testframe.setVisible(true);//根据原有试题再次创建TestFrame
        dispose();//关掉自己(ShowResultDialog)
    }//GEN-LAST:event_jButtonAgainActionPerformed

    private void jButtonOKActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonOKActionPerformed
        // TODO add your handling code here:
        testdata.mfr.startTest.setEnabled(true);//main.java中为了防止瞬间多次点击 将其置为了失效状态 这里恢复正常状态
        //testdata.mfr.setDefaultCloseOperation(javax.swing.JFrame.EXIT_ON_CLOSE);
        testdata.mfr.setVisible(true);//重新显示被隐藏的MainFrame
        dispose();//关掉自己(ShowResultDialog)
    }//GEN-LAST:event_jButtonOKActionPerformed
    /**
     * @param args the command line arguments 这个main()是用来测试的
     */
    /*  public static void main(String args[]) {
    java.awt.EventQueue.invokeLater(new Runnable() {

    public void run() {
    ShowResultDialog dialog = new ShowResultDialog();
    dialog.addWindowListener(new java.awt.event.WindowAdapter() {

    public void windowClosing(java.awt.event.WindowEvent e) {
    System.exit(0);
    }
    });
    dialog.setVisible(true);
    }
    });
    }*/
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButtonAgain;
    private javax.swing.JButton jButtonOK;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JSeparator jSeparator1;
    private javax.swing.JTable jTable1;
    private javax.swing.JLabel resultText;
    private javax.swing.JLabel score;
    // End of variables declaration//GEN-END:variables
}
