/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package vocabulary;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;

/**
 *
 * @author Administrator
 */
public class TestFrame extends JFrame implements ActionListener, MouseListener {

    JButton skip = new JButton("跳过");
    JButton submit = new JButton("交卷");
    JButton next = new JButton("下一题");
    JPanel mainPanel = new JPanel();
    MainFrame mfr;
    Vector<String> testType;//范围(all selected) 类型(c2e e2c spell) 难易(goeasy gohard rand) 数量
    int selectRows[];
    ArrayList<ArrayList<String>> content = new ArrayList<ArrayList<String>>();//测试的总体 包含的是一个个单词条目
    //答题区元素
    JPanel pWorkPlace = new JPanel();
    JLabel quest = new JLabel("");
    ButtonGroup bg = new ButtonGroup();
    JRadioButton answer[] = new JRadioButton[4];
    ImagePanel pic;
    ArrayList<String> dataHead = new ArrayList<String>();//记录问题
    ArrayList<String[]> dataBody = new ArrayList<String[]>();//记录答案
    ArrayList<Integer> rightPos = new ArrayList<Integer>();//记录正确答案的位置
    ArrayList<Integer> selectPos = new ArrayList<Integer>();//记录所选答案的位置 英译汉和汉译英
    ArrayList<String> spellingAnswers = new ArrayList<String>();//记录拼写题所填的答案
    ArrayList<String> result = new ArrayList<String>();//记录该题是否做对
    int pos = 0;
    int testNum;//试题数量
    JLabel currentSub = new JLabel();
    JTextField inputField = new JTextField(20);//拼写题中的输入域
    int skipNum;//跳过的题目数
    int rightNum;//做对的题目数
    int wrongNum;//做错的题目数
    String temprecord;

    TestFrame(MainFrame mfr, ArrayList<String> dataHead, ArrayList<String[]> dataBody, ArrayList<Integer> rightPos) {
        this.dataHead = dataHead;
        this.dataBody = dataBody;//传入试题册
        this.rightPos = rightPos;
        this.mfr = mfr;//传入窗口 用于控制显隐
        testNum = dataHead.size();
        initAnswers();//初始化所作答案 均置为错误答案       

        this.setLayout(null);
        Toolkit tool = Toolkit.getDefaultToolkit();
        Dimension screensize = tool.getScreenSize();
        Box box = Box.createVerticalBox();
        if (mfr.bg_type.getSelection().getActionCommand().equals("c2e") || mfr.bg_type.getSelection().getActionCommand().equals("e2c")) {
            quest.setText(dataHead.get(pos));
            box.add(Box.createVerticalStrut(15));
            box.add(quest);
            box.add(Box.createVerticalStrut(5));
            for (int i = 0; i < 4; i++) {
                answer[i] = new JRadioButton("");
                answer[i].setText(dataBody.get(pos)[i]);
                answer[i].addActionListener(this);
                answer[i].addMouseListener(this);
                bg.add(answer[i]);
                box.add(answer[i]);
                box.add(Box.createVerticalStrut(5));
            }
            add(box);
            box.setBounds(screensize.width / 2 - 250, 0, 500, 160);//加大宽度以显示完全
        } else {
            quest.setText(dataHead.get(0));
            box.add(Box.createVerticalStrut(15));
            box.add(quest);
            box.add(Box.createVerticalStrut(5));
            inputField.setBorder(BorderFactory.createLineBorder(Color.BLACK));
            inputField.addActionListener(this);
            inputField.setToolTipText("tip:输入完后按两次回车键自动进入下一题");
            box.add(inputField);
            add(box);
            box.setBounds(screensize.width / 2 - 200, 0, 400, 80);
        }

        add(next);
        next.setBounds(screensize.width / 2 - 50, 140, 80, 35);
        add(submit);
        submit.setBounds(screensize.width / 2 - 50, 190, 80, 35);
        add(skip);
        skip.setBounds(screensize.width / 2 - 50, 240, 80, 35);
        add(currentSub);
        currentSub.setText("第" + Integer.toString(pos + 1) + "道 [共" + dataHead.size() + "题]");
        currentSub.setBounds(5, 5, 200, 70);
        next.addActionListener(this);
        skip.addActionListener(this);
        submit.addActionListener(this);
        submit.setToolTipText("注意：当前题目的作答不会被保存！");
        next.setToolTipText("保存当前结果并进入下一题");
        skip.setToolTipText("不保存当前结果，直接进入下一题");
        if (mfr.bg_type.getSelection().getActionCommand().equals("c2e") || mfr.bg_type.getSelection().getActionCommand().equals("e2c")) {
            next.setVisible(false);
        }
        setTitle("测验");
        this.setUndecorated(true);
        this.setDefaultCloseOperation(DO_NOTHING_ON_CLOSE);//使关闭按钮失效
        this.setSize(screensize);
        setResizable(false);
        this.setLocationRelativeTo(null);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == submit) {
            ProcessTest();
            ReportDialog dlg = new ReportDialog(generateTestData(), rightNum, wrongNum, skipNum, 0);//未到达最后一题时单击提交           
        } else if (e.getSource() == next) {
            SpellingNextProcess();//选择题自动跳转到下一题 不需要next按钮
        } else if (e.getSource() == skip) {
            if (mfr.bg_type.getSelection().getActionCommand().equals("c2e") || mfr.bg_type.getSelection().getActionCommand().equals("e2c")) {
                MutualTranslatinoSkipProcess();
            } else {
                SpellingSkipProcess();
            }
            skipNum++;
        } else if (e.getSource() == inputField) {
            next.requestFocus();//焦点控制 输入完按回车键自动将焦点设为next
        } else if (e.getSource() == answer[0]) {
            temprecord = null;
            selectPos.set(pos, 0);
            try {
                Thread.sleep(500);
            } catch (InterruptedException ex) {
                Logger.getLogger(TestFrame.class.getName()).log(Level.SEVERE, null, ex);
            }
            gotoNext();

        } else if (e.getSource() == answer[1]) {
            temprecord = null;
            selectPos.set(pos, 1);
            try {
                Thread.sleep(500);
            } catch (InterruptedException ex) {
                Logger.getLogger(TestFrame.class.getName()).log(Level.SEVERE, null, ex);
            }
            gotoNext();

        } else if (e.getSource() == answer[2]) {
            temprecord = null;
            selectPos.set(pos, 2);
            try {
                Thread.sleep(500);
            } catch (InterruptedException ex) {
                Logger.getLogger(TestFrame.class.getName()).log(Level.SEVERE, null, ex);
            }
            gotoNext();

        } else if (e.getSource() == answer[3]) {
            temprecord = null;
            selectPos.set(pos, 3);
            try {
                Thread.sleep(500);
            } catch (InterruptedException ex) {
                Logger.getLogger(TestFrame.class.getName()).log(Level.SEVERE, null, ex);
            }
            gotoNext();
        }
    }

    void gotoNext() {
        pos++;
        if (pos < testNum) {
            currentSub.setText("第" + Integer.toString(pos + 1) + "道 [共" + dataHead.size() + "题]");
            quest.setText(dataHead.get(pos));
            for (int i = 0; i < 4; i++) {
                answer[i].setText(dataBody.get(pos)[i]);
            }
            answer[0].requestFocus();//next之后将焦点返还给单选按钮
            bg.clearSelection();
        } else {
            for (int i = 0; i < 4; i++) {
                answer[i].setEnabled(false);
            }
            submit.requestFocus();
            ProcessTest();
            ReportDialog dlg = new ReportDialog(generateTestData(), rightNum, wrongNum, skipNum, 1);//做完最后一题自动提交
        }
    }

    void printAnswers() {
        if (mfr.bg_type.getSelection().getActionCommand().equals("c2e") || mfr.bg_type.getSelection().getActionCommand().equals("e2c")) {
            for (int i = 0; i < selectPos.size(); i++) {
                System.out.println(selectPos.get(i));
            }
        } else {
            for (int i = 0; i < spellingAnswers.size(); i++) {
                System.out.println(spellingAnswers.get(i));
            }
        }
    }

    void MutualTranslatinoSkipProcess() {
        pos++;
        if (pos < testNum) {
            currentSub.setText("第" + Integer.toString(pos + 1) + "道 [共" + dataHead.size() + "题]");
            quest.setText(dataHead.get(pos));
            for (int i = 0; i < 4; i++) {
                answer[i].setText(dataBody.get(pos)[i]);
            }
            answer[0].requestFocus();//next之后将焦点返还给单选按钮
            bg.clearSelection();
        } else {
            for (int i = 0; i < 4; i++) {
                answer[i].setEnabled(false);
            }
            submit.requestFocus();
            ProcessTest();
            ReportDialog dlg = new ReportDialog(generateTestData(), rightNum, wrongNum, skipNum, 1);//做完最后一题自动提交
        }
    }

    void SpellingNextProcess() {
        if (inputField.getText() == null || inputField.getText().equals("")) {
            JOptionPane.showConfirmDialog(this, "请输入单词", "注意", JOptionPane.CLOSED_OPTION, JOptionPane.INFORMATION_MESSAGE);
            inputField.requestFocus();
        } else {
            spellingAnswers.set(pos, inputField.getText());
            pos++;
            if (pos < testNum) {
                currentSub.setText("第" + Integer.toString(pos + 1) + "道 [共" + dataHead.size() + "题]");
                quest.setText(dataHead.get(pos));
                inputField.setText(null);
                inputField.requestFocus();//next之后将焦点返还给文本框
            } else {
                inputField.setText(null);
                inputField.setEditable(false);
                submit.requestFocus();
                ProcessTest();
                ReportDialog dlg = new ReportDialog(generateTestData(), rightNum, wrongNum, skipNum, 1);//做完最后一题自动提交
            }
        }
    }

    void SpellingSkipProcess() {
        pos++;
        if (pos < testNum) {
            currentSub.setText("第" + Integer.toString(pos + 1) + "道 [共" + dataHead.size() + "题]");
            quest.setText(dataHead.get(pos));
            inputField.setText(null);
            inputField.requestFocus();//next之后将焦点返还给文本框
        } else {
            inputField.setText(null);
            inputField.setEditable(false);
            submit.requestFocus();
            ProcessTest();
            ReportDialog dlg = new ReportDialog(generateTestData(), rightNum, wrongNum, skipNum, 1);//做完最后一题自动提交
        }
    }

    void ProcessTest() {//判卷 给出成绩
        rightNum = 0;
        wrongNum = 0;
        skipNum = 0;
        result.clear();
        if (mfr.bg_type.getSelection().getActionCommand().equals("c2e") || mfr.bg_type.getSelection().getActionCommand().equals("e2c")) {
            for (int i = 0; i < testNum; i++) {
                if (selectPos.get(i) == rightPos.get(i)) {
                    rightNum++;
                    result.add("r");
                } else if (selectPos.get(i) == -1) {
                    skipNum++;
                    result.add("s");
                } else {
                    wrongNum++;
                    result.add("w");
                }
            }
        } else {
            for (int i = 0; i < testNum; i++) {
                if (spellingAnswers.get(i).equals(dataBody.get(i)[0])) {
                    rightNum++;
                    result.add("r");
                } else if (spellingAnswers.get(i).equals("")) {
                    skipNum++;
                    result.add("s");
                } else {
                    wrongNum++;
                    result.add("w");
                }
            }
        }
    }

    void initAnswers() {
        if (mfr.bg_type.getSelection().getActionCommand().equals("c2e") || mfr.bg_type.getSelection().getActionCommand().equals("e2c")) {
            for (int i = 0; i < testNum; i++) {
                selectPos.add(-1);
            }
        } else {
            for (int i = 0; i < testNum; i++) {
                spellingAnswers.add("");
            }
        }
    }

    TestData generateTestData() {
        TestData ob = new TestData();
        ob.dataBody = this.dataBody;
        ob.dataHead = this.dataHead;
        ob.result = this.result;
        ob.rightPos = this.rightPos;
        ob.selectPos = this.selectPos;
        ob.spellingAnswers = this.spellingAnswers;
        ob.skipNum = this.skipNum;
        ob.rightNum = this.rightNum;
        ob.wrongNum = this.wrongNum;
        ob.mfr = this.mfr;
        ob.tfr = this;
        return ob;
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
        JRadioButton temp = (JRadioButton) e.getSource();
        String text = temp.getText();
        temprecord = text;
        temp.setBackground(Color.red);
        temp.setText("<html><body><u>" + text + "</u></body></html>");
        this.setCursor(Cursor.getPredefinedCursor(Cursor.HAND_CURSOR));
    }

    public void mouseExited(MouseEvent e) {
        JRadioButton temp = (JRadioButton) e.getSource();
        temp.setBackground(null);//"恢复本色"
        if (temprecord != null) {
            temp.setText(temprecord);
        }
        this.setCursor(Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));
    }
}

