/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package vocabulary;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

/**
 *
 * @author Administrator
 */
public class WaitDialog extends JFrame implements MouseListener {

    JProgressBar progressBar = new JProgressBar();

    public WaitDialog() {
        progressBar.setForeground(new Color(255, 0, 0));
        progressBar.setStringPainted(true);
        add(progressBar);
        setUndecorated(true);
        pack();
        setTitle("WAITING");
        this.setLocationRelativeTo(null);
        this.setResizable(false);
        this.setDefaultCloseOperation(JFrame.DO_NOTHING_ON_CLOSE);
        progressBar.addMouseListener(this);
        setVisible(true);
    }

    public void adoptDeterminate(int maxValue) {
        progressBar.setMaximum(maxValue);
        progressBar.setVisible(true);
    }

    public void setValue(int value) {
        progressBar.setValue(value);
        if (value <= progressBar.getMaximum()) {
            progressBar.setString("正在处理数据，请稍候...");
        }
    }

    public void finishDeterminate() {

        this.dispose();
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
        setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
    }

    public void mouseExited(MouseEvent e) {
        // setCursor(Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));
    }

    public static void main(String args[]) {
        WaitDialog dlg = new WaitDialog();
        dlg.adoptDeterminate(100);
        for (int i = 0; i < 100; i++) {
            dlg.setValue(i);
            try {
                Thread.sleep(50);
            } catch (InterruptedException ex) {
                Logger.getLogger(WaitDialog.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        dlg.finishDeterminate();
    }
}
