/*
 * Demonstra que quando criamos um PeerID novo, a partir da classe IDFactory,
 * esse PeerID é aleatório, a não ser que forneçamos um byte[] array como
 * parâmetro na criação.
 */
package testes;

import net.jxta.id.IDFactory;
import net.jxta.peergroup.PeerGroupID;

public class NewPeerID {

    public static void main(String[] args) {

        /* As 2 declarações abaixo são a mesma coisa */
//        byte[] MySeed = new byte[]{0, 1, 2, 3, 4, 5, 6};
//        byte[] MySeed = {0, 1, 2, 3, 4, 5, 6};


        /* Esses 2 devem ser diferentes, pois a geração do PeerID é randômica. Isso significa que
         * cada vez que o programa é executado, o peer recebe um novo ID (se esse for o esquema
         * que escolhermos utilizar) */
        System.out.println("IDs devem ser diferentes (gerados aleatoriamente...)");
        System.out.println("PeerID no netgroup:   " + IDFactory.newPeerID(PeerGroupID.defaultNetPeerGroupID));
        System.out.println("PeerID no netgroup:   " + IDFactory.newPeerID(PeerGroupID.defaultNetPeerGroupID) + "\n");

        /* Esses 2 devem ser iguais, pois estou fornecendo um byte[] array */
        System.out.println("IDs devem ser iguais...");
        System.out.println("PeerID no netgroup:   " + IDFactory.newPeerID(PeerGroupID.defaultNetPeerGroupID, new byte[]{0, 1, 2, 3, 4, 5, 6}));
        System.out.println("PeerID no netgroup:   " + IDFactory.newPeerID(PeerGroupID.defaultNetPeerGroupID, new byte[]{0, 1, 2, 3, 4, 5, 6}) + "\n");

        /* Esses 2 devem ser diferentes */
        System.out.println("IDs devem ser diferentes (gerados aleatoriamente...)");
        System.out.println("PeerID no worldgroup: " + IDFactory.newPeerID(PeerGroupID.worldPeerGroupID));
        System.out.println("PeerID no worldgroup: " + IDFactory.newPeerID(PeerGroupID.worldPeerGroupID) + "\n");

        /* Esses 2 devem ser iguais, pois forneço o byte[] array */
        System.out.println("IDs devem ser iguais...");
        System.out.println("PeerID no worldgroup: " + IDFactory.newPeerID(PeerGroupID.worldPeerGroupID, new byte[]{0, 1, 2, 3, 4, 5, 6}));
        System.out.println("PeerID no worldgroup: " + IDFactory.newPeerID(PeerGroupID.worldPeerGroupID, new byte[]{0, 1, 2, 3, 4, 5, 6}));
    }
}
