/*
 * Classe do METADADO
 */
package trabalho3sd;

import net.jxta.peer.PeerID;
import net.jxta.util.JxtaBiDiPipe;

/*
 * @author Gustavo Luvizotto Cesar - 6783544 - gustavoluvizotto@gmail.com
 * @author Leonardo Lourenço Crespilho - 5124310 - lcrespilho@gmail.com
 * @author Murilo Alencar Alves Júnior - muriloaajruspec@gmail.com
 * 
 */
public class Metadado {

    private String fileName; // nome do arquivo ("recurso") presente no EDGE e que está sendo compartilhado
    private long lastModification;     // data da última atualização no arquivo. Utilizado para comprar com outros arquivos de mesmo nome
    private String state;      // pode ser { DISPONIVEL, EXECUTANDO } e indica o estado do arquivo. Deve ser manipulado apenas pelo RDV
    private PeerID peerID;  // PeerID do EDGE que contém o arquivo e o publicou
    private JxtaBiDiPipe RDV2PeerBiDiPipeSocket; // É manipulado apenas pelo RDV, e contém o socket do pipe que o EDGE utilizou para se conectar ao RDV
    
    @Override
    public String toString() {
        return "Metadado{" + "ID=" + peerID.toString() + ", NomeArquivo=" + fileName + ", Estado=" + state + ", UltimaModificacao=" + lastModification + ", BiDiPipeWithRDV=" + RDV2PeerBiDiPipeSocket.toString() + '}';
    }

    public PeerID getPeerID() {
        return peerID;
    }

    public void setPeerID(PeerID peerID) {
        this.peerID = peerID;
    }

    public String getFileName() {
        return fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getState() {
        return state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public long getLastModification() {
        return lastModification;
    }

    public void setLastModification(long lastModification) {
        this.lastModification = lastModification;
    }

    public JxtaBiDiPipe getRDV2PeerBiDiPipeSocket() {
        return RDV2PeerBiDiPipeSocket;
    }

    public void setRDV2PeerBiDiPipeSocket(JxtaBiDiPipe RDV2PeerBiDiPipeSocket) {
        this.RDV2PeerBiDiPipeSocket = RDV2PeerBiDiPipeSocket;
    }
}
