/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package com.seclust;

import Annas.Graph.Node;
import Annas.Graph.Graph;
import Annas.Graph.Arc;
import Annas.Graph.Util.Prim;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
/**
 *
 * @author baga
 */

public class Prims {
    private int nilaiNode;
    private int lenMax;
    private Graph theGraph;
    private Graph resultGraph;

    public Prims(int nilaiNode, double[] result) {
        theGraph = new Graph();
        this.nilaiNode = nilaiNode;
        for(int i=0; i<nilaiNode; i++) {
            theGraph.addNode("" + (i+1));
        }
        int resCount = 0;
        for (int i=0; i<nilaiNode; i++) {
            for(int j=i+1; j<nilaiNode; j++) {
                theGraph.addArc("" + (i+1), "" + (j+1), result[resCount]);
                resCount++;
            }
        }

        Prim resPrim = new Prim(theGraph);
        resultGraph = resPrim.run();
    }

    public Graph initGraph() {
        return theGraph;
    }

    public Graph resPrimGraph() {
        return resultGraph;
    }

    public Double[] getEdges() {
        ArrayList edges = new ArrayList();
        ArrayList alNodeMap = resultGraph.getNodeMap();
        Iterator iterNodeMap = alNodeMap.iterator();
        while(iterNodeMap.hasNext()) {
            Node tempNode = (Node) iterNodeMap.next();
            ArrayList alArc = resultGraph.getArcs(tempNode);
            Iterator iterArc = alArc.iterator();
            while(iterArc.hasNext()) {
                Arc tempArc = (Arc) iterArc.next();
                edges.add(tempArc.getWeight());
            }
        }
        Object[] val = (Object[]) edges.toArray(new Double[edges.size()]);
        Arrays.sort(val, Collections.reverseOrder());
        return  (Double[]) val;
    }

    public Double[] getEdgesOrig() {
        ArrayList edges = new ArrayList();
        ArrayList alNodeMap = theGraph.getNodeMap();
        Iterator iterNodeMap = alNodeMap.iterator();
        while(iterNodeMap.hasNext()) {
            Node tempNode = (Node) iterNodeMap.next();
            ArrayList alArc = theGraph.getArcs(tempNode);
            Iterator iterArc = alArc.iterator();
            while(iterArc.hasNext()) {
                Arc tempArc = (Arc) iterArc.next();
                edges.add(tempArc.getWeight());
            }
        }
        return (Double[]) edges.toArray(new Double[edges.size()]);
    }

//   public static void main(String[] args) {
////       double[] edges = {1.0, 2.0, 11.0, 15.0, 3.0, 9.0, 11.0, 5.0, 7.0, 5.0, 1.0,
////        2.0, 7.0, 4.5, 6.0};
//       CosSim cosSim = new CosSim();
//       Double[][] matrix = cosSim.getMatrixResult();
//       double[] matDistance = cosSim.allDistance();
//
//       Prims thePrims = new Prims(matrix.length, matDistance);
//       Double[] edgesVal = thePrims.getEdges();
//       for(Double d : edgesVal) {
//           System.out.println(d.doubleValue());
//       }
////       while(iterGraph.hasNext()) {
////           Node theNode = (Node) iterGraph.next();
////           System.out.println(theNode);
////           ArrayList alArc = theGraph.getArcs(theNode);
////           Iterator iterArc = alArc.iterator();
////           int i = 1;
////           while(iterArc.hasNext()) {
////               System.out.println(iterArc.next() + " "+ i++);
////           }
////       }
//   }

}
