/**
 * Bachelorarbeit: Crowdsourcing- Systeme Manipulation und Resistenz
 * von Jens Bothur
 */
package jens.bothur.occt.automatons;

import java.util.Set;

import jens.bothur.occt.domainobjects.ReviewerGroup;

/**
 * Dieses Interface beschreibt einen Datensammler (Data Miner) welcher aus dem
 * gesamten System Bewerter-Gruppen (Reviewer Groups) heraussucht.
 * 
 * 
 * @author Jens Bothur
 */
public interface IReviewerGroupDataMiner {

	/**
	 * Gibt eine Menge mit allen Bewerter-Gruppen ber das gesamte System
	 * wieder. Diese sollten mglichst adhoc berechnet werden.
	 * 
	 * @return Ein {@link Set} mit allen {@link ReviewerGroup}s des gesamten
	 *         Systems.
	 */
	public Set<ReviewerGroup> getAllReviewerGroups();

}
