/**
 * Bachelorarbeit: Crowdsourcing- Systeme Manipulation und Resistenz
 * von Jens Bothur
 */
package jens.bothur.occt.automatons.security_framework.group_calculators;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

import jens.bothur.occt.domainobjects.ReviewerGroup;

/**
 * Diese Klasse reprsentiert den berechner fr den SpamScore bezglich der
 * Gruppen-Objekt-Anzahl. Hierbei erhalten Gruppen die bei mehr Objekten
 * zusammen gearbeitet haben einen schlechteren Score als Gruppen mit weniger
 * Objekten.
 * 
 * @author Jens Bothur
 */
public class GroupSupportCountSpamScoreCalculator implements
		IGroupSpamScoreCalculator {

	/**
	 * Berechnet den SpamScore bezglich der Gruppen-Objekt-Anzahl fr eine Menge
	 * von Bewerter-Gruppen. Diese Menge sollten alle Gruppen des Systems sein.
	 * 
	 * @param reviewerGroups
	 *            Ein {@link Set} von {@link ReviewerGroup}. Dies sollten alle
	 *            Bewerter-Gruppen des Systems sein.
	 * @return Eine {@link Map} welche den reviewerGroups ihren jeweiligen
	 *         berechneten SpamScore zuordnet.
	 */
	public static Map<ReviewerGroup, Double> calculateGroupSupportCountSpamScore(
			Set<ReviewerGroup> reviewerGroups) {
		Map<ReviewerGroup, Double> result = new LinkedHashMap<ReviewerGroup, Double>();

		double largestObjectCount = 0;
		for (ReviewerGroup reviewerGroup : reviewerGroups) {
			int objectCount = reviewerGroup.getCollaboratedObjects().size();
			if (objectCount > largestObjectCount) {
				largestObjectCount = objectCount;
			}
		}
		for (ReviewerGroup reviewerGroup : reviewerGroups) {
			double score = ((double) reviewerGroup.getCollaboratedObjects()
					.size()) / largestObjectCount;
			result.put(reviewerGroup, score);
		}

		return result;
	}

}
