/**
dda * Bachelorarbeit: Crowdsourcing- Systeme Manipulation und Resistenz
 * von Jens Bothur
 */
package jens.bothur.occt.automatons.security_framework.single_calculators;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

import jens.bothur.occt.domainobjects.RateableObject;
import jens.bothur.occt.domainobjects.User;

/**
 * Diese Klasse reprsentiert den Berechner fr die Allgemeine Abweichung eines
 * Benutzer und den daraus resultierenden Spamming-Score.
 * 
 * @author Jens Bothur
 */
public class GeneralDeviationCalculator implements ISingleSpamScoreCalculator {

	/**
	 * Berechnet die Allgemeine Abweichung fr eine Menge von Benutzern. Diese
	 * Nutzer werden in einer Map bergeben in der sie jeweils zu einer Menge
	 * ihrer bewerteten Objekte zugeordnet werden.
	 * 
	 * @param usersToRatedObjects
	 *            Eine {@link Map} in der die {@link User} einem {@link Set}
	 *            ihrer jeweiligen {@link RateableObject} zugeordnet werden
	 * 
	 * @return Eine {@link Map} in der die obigen {@link User} ihrer berechneten
	 *         Allgemeine Abweichung zugeordnet werden.
	 */
	public static Map<User, Double> calculateGeneralDeviation(
			Map<User, Set<RateableObject>> usersToRatedObjects) {
		Map<User, Double> result = new HashMap<User, Double>();

		for (User user : usersToRatedObjects.keySet()) {
			double generalDeviationForUser = calculateGeneralDeviationForUser(
					user, usersToRatedObjects.get(user));
			result.put(user, generalDeviationForUser);
		}

		return result;
	}

	/**
	 * Berechnet die Allgemeine Abweichung eines Benutzers und eine Menge aller
	 * von diesem Benutzer abgegebene Bewertungen.
	 * 
	 * @param user
	 *            Der {@link User}.
	 * @param set
	 *            Ein {@link Set} von {@link RateableObject} die der Benutzer
	 *            bewertet hat.
	 * @return Die berechnete Allgemeine Abweichung im Intervall [0;1] als
	 *         {@link Double}.
	 */
	private static double calculateGeneralDeviationForUser(User user,
			Set<RateableObject> set) {
		double result = 0.0;

		if (!set.isEmpty()) {
			for (RateableObject rateableObject : set) {
				result += Math.abs(rateableObject.getReviewForReviewer(user)
						.getNormalizedRating()
						- rateableObject.getAverageReview()
								.getNormalizedRating());
			}
			result = result / set.size();
		}

		return result;
	}

}
