/**
 * Bachelorarbeit: Crowdsourcing- Systeme Manipulation und Resistenz
 * von Jens Bothur
 */
package jens.bothur.occt.domainvalues;

import java.util.HashMap;
import java.util.Map;

/**
 * Diese Klasse reprsentiert das Vertrauenslevel eines Benutzers im OCCT. Es
 * reicht von 0 - 10 und hat maximal eine Nachkommastelle.
 * 
 * 
 * @author Jens Bothur
 */
public class ConfidenceLevel {

	/**
	 * Eine {@link Map} welche alle mglichen {@link ConfidenceLevel} hlt. Man
	 * beachte das das entsprechende {@link ConfidenceLevel} fr Vertrauenslevel
	 * = 5,7 unter dem Key = 57 abgelegt ist.
	 */
	private static final Map<Integer, ConfidenceLevel> ALL_CONFIDENCE_LEVELS;

	/**
	 * Der static-block zum befllen der #ALL_CONFIDENCE_LEVELS map.
	 */
	static {
		ALL_CONFIDENCE_LEVELS = new HashMap<Integer, ConfidenceLevel>();
		for (int i = 0; i <= 100; i++) {
			ALL_CONFIDENCE_LEVELS.put(i, new ConfidenceLevel(i));
		}
	}

	/**
	 * Das Vertrauenslevel welches dieses {@link ConfidenceLevel} darstellt * 10
	 * als int.
	 */
	private final int _confidenceLevelTimes10;

	/**
	 * Privater Konstruktor zur erstellung von {@link ConfidenceLevel}.
	 * 
	 * @param confidenceLevelTimes10
	 *            Das gewnschte Vertrauenslevel *10 als int.
	 */
	private ConfidenceLevel(int confidenceLevelTimes10) {
		_confidenceLevelTimes10 = confidenceLevelTimes10;
	}

	/**
	 * Gibt das Vertrauenslevel welches dieses {@link ConfidenceLevel} darstellt
	 * * 10 als int zurck.
	 * 
	 * @return Das Vertrauenslevel welches dieses {@link ConfidenceLevel}
	 *         darstellt * 10 als int.
	 */
	public int getValueTimes10() {
		return _confidenceLevelTimes10;
	}

	/**
	 * Gibt das Vertrauenslevel welches dieses {@link ConfidenceLevel} darstellt
	 * * als double zurck.
	 * 
	 * @return Das Vertrauenslevel welches dieses {@link ConfidenceLevel}
	 *         darstellt als double.
	 */
	public double getValue() {
		return _confidenceLevelTimes10 / 10.0;
	}

	/**
	 * Die Factory um ein {@link ConfidenceLevel} zu erhalten. Sie wird mit dem
	 * gewnschten Vertrauenslevel *10 als int aufgerufen.
	 * 
	 * @param confidenceLevelTimes10
	 *            Das gewnschten Vertrauenslevel *10 als int.
	 * @return Das entsprechende {@link ConfidenceLevel}.
	 */
	public static ConfidenceLevel getConfidenceLevelByIntTimes10(
			Integer confidenceLevelTimes10) {
		ConfidenceLevel result = ALL_CONFIDENCE_LEVELS
				.get(confidenceLevelTimes10);
		if (result == null) {
			throw new IllegalArgumentException(
					confidenceLevelTimes10
							+ " is not an allowed confidence level or it cannot be found.");
		}
		return result;
	}

	/**
	 * Die Factory um ein {@link ConfidenceLevel} zu erhalten. Sie wird mit dem
	 * gewnschten Vertrauenslevel als double aufgerufen.
	 * 
	 * @param confidenceLevelTimes10
	 *            Das gewnschten Vertrauenslevel als double.
	 * @return Das entsprechende {@link ConfidenceLevel}.
	 */
	public static ConfidenceLevel getConfidenceLevelByDouble(
			double confidenceLevel) {
		Integer confidenceLevelTimes10 = (int) (confidenceLevel * 10);
		return getConfidenceLevelByIntTimes10(confidenceLevelTimes10);
	}
}
