/**
 * Bachelorarbeit: Crowdsourcing- Systeme Manipulation und Resistenz
 * von Jens Bothur
 */
package jens.bothur.occt.services;

import java.util.Collection;
import java.util.List;

import jens.bothur.occt.domainobjects.RateableObject;

/**
 * Interface fr Services welche sich um bewertbare Objekte kmmern.
 * 
 * @author Jens Bothur
 */
public interface IRateableObjectService {

	/**
	 * Gibt ein bewertbares Objekt fr eine bergebene ID zurck.
	 * 
	 * @param id
	 *            Die ID des gesuchten bewertbaren Objekts als long.
	 * @return Das zur id entsprechende {@link RateableObject},
	 *         <code>null</code> wenn kein bewertbares Objekt mit dieser ID
	 *         existert.
	 */
	public RateableObject getRateableObject(long id);

	/**
	 * Gibt eine Liste mit allen bewertbaren Objekten zurck.
	 * 
	 * @return Eine {@link List} von {@link RateableObject}s.
	 */
	public Collection<RateableObject> getAllRateableObjects();

	/**
	 * Legt einen neues bewertbares Objekt im System an.
	 * 
	 * @param ratebaleObject
	 *            Ein {@link RateableObject} das dem System hinzugefgt werden
	 *            soll.
	 */
	public void registerRateableObject(RateableObject rateableObject);
}
