/**
 * Bachelorarbeit: Crowdsourcing- Systeme Manipulation und Resistenz
 * von Jens Bothur
 */
package jens.bothur.occt.automatons.security_framework.group_calculators;

import static org.junit.Assert.assertTrue;

import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

import jens.bothur.occt.domainobjects.RateableObject;
import jens.bothur.occt.domainobjects.ReviewerGroup;
import jens.bothur.occt.domainobjects.User;
import jens.bothur.occt.domainvalues.Review;

import org.junit.Before;
import org.junit.Test;

/**
 * Test fr die Klasse: {@link EarlyTimeFrameSpamScoreCalculator}.
 * 
 * @author Jens Bothur
 */
public class EarlyTimeFrameSpamScoreCalculatorTest {

	private Set<ReviewerGroup> _reviewerGroups;

	private ReviewerGroup _group1;
	private ReviewerGroup _group2;
	private ReviewerGroup _group3;

	private final User USER1 = new User("1");
	private final User USER2 = new User("2");
	private final User USER3 = new User("3");

	@SuppressWarnings("deprecation")
	private final RateableObject OBJECT1 = new RateableObject(new Date(84, 3,
			30, 17, 22, 22));
	@SuppressWarnings("deprecation")
	private final RateableObject OBJECT2 = new RateableObject(new Date(84, 3,
			30, 17, 22, 22));
	@SuppressWarnings("deprecation")
	private final RateableObject OBJECT3 = new RateableObject(new Date(84, 3,
			30, 17, 22, 22));
	@SuppressWarnings("deprecation")
	private final RateableObject OBJECT3a = new RateableObject(new Date(84, 3,
			30, 17, 22, 22));
	@SuppressWarnings("deprecation")
	private final RateableObject OBJECT4 = new RateableObject(new Date(84, 3,
			30, 17, 22, 22));
	@SuppressWarnings("deprecation")
	private final RateableObject OBJECT5 = new RateableObject(new Date(84, 3,
			30, 17, 22, 22));
	@SuppressWarnings("deprecation")
	private final RateableObject OBJECT6 = new RateableObject(new Date(84, 3,
			30, 17, 22, 22));
	@SuppressWarnings("deprecation")
	private final RateableObject OBJECT7 = new RateableObject(new Date(84, 3,
			30, 17, 22, 22));
	@SuppressWarnings("deprecation")
	private final RateableObject OBJECT8 = new RateableObject(new Date(84, 3,
			30, 17, 22, 22));

	/**
	 * @throws java.lang.Exception
	 */
	@SuppressWarnings({ "serial", "deprecation" })
	@Before
	public void setUp() throws Exception {

		OBJECT1.rate(USER1, Review.ONE_STAR_REVIEW, new Date(84, 3, 30,
				17, 22, 22));
		OBJECT2.rate(USER1, Review.ONE_STAR_REVIEW, new Date(84, 3, 30,
				17, 22, 22));
		OBJECT3.rate(USER1, Review.ONE_STAR_REVIEW, new Date(84, 3, 30,
				17, 22, 22));
		OBJECT1.rate(USER2, Review.ONE_STAR_REVIEW, new Date(84, 3, 30,
				17, 22, 22));
		OBJECT2.rate(USER2, Review.ONE_STAR_REVIEW, new Date(84, 3, 30,
				17, 22, 22));
		OBJECT3.rate(USER2, Review.ONE_STAR_REVIEW, new Date(84, 3, 30,
				17, 22, 22));

		_group1 = new ReviewerGroup(new LinkedHashSet<User>() {
			{
				add(USER1);
				add(USER2);
			}
		}, new LinkedHashSet<RateableObject>() {
			{
				add(OBJECT1);
				add(OBJECT2);
				add(OBJECT3);
			}
		});

		OBJECT3a.rate(USER1, Review.ONE_STAR_REVIEW, new Date(84, 3,
				30, 17, 22, 22));
		OBJECT4.rate(USER1, Review.ONE_STAR_REVIEW, new Date(84, 3, 30,
				18, 22, 22));
		OBJECT5.rate(USER1, Review.ONE_STAR_REVIEW, new Date(84, 3, 30,
				19, 22, 22));
		OBJECT3a.rate(USER3, Review.ONE_STAR_REVIEW, new Date(84, 3,
				30, 18, 52, 22));
		OBJECT4.rate(USER3, Review.ONE_STAR_REVIEW, new Date(84, 3, 30,
				22, 22, 22));
		OBJECT5.rate(USER3, Review.ONE_STAR_REVIEW, new Date(84, 3, 31,
				0, 22, 22));

		_group2 = new ReviewerGroup(new LinkedHashSet<User>() {
			{
				add(USER1);
				add(USER3);
			}
		}, new LinkedHashSet<RateableObject>() {
			{
				add(OBJECT3a);
				add(OBJECT4);
				add(OBJECT5);
			}
		});

		OBJECT6.rate(USER1, Review.ONE_STAR_REVIEW, new Date(84, 3, 30,
				17, 22, 22));
		OBJECT7.rate(USER1, Review.ONE_STAR_REVIEW, new Date(85, 3, 30,
				17, 22, 22));
		OBJECT8.rate(USER1, Review.ONE_STAR_REVIEW, new Date(86, 3, 30,
				17, 22, 22));
		OBJECT6.rate(USER2, Review.ONE_STAR_REVIEW, new Date(87, 3, 30,
				17, 22, 22));
		OBJECT7.rate(USER2, Review.ONE_STAR_REVIEW, new Date(88, 3, 30,
				17, 22, 22));
		OBJECT8.rate(USER2, Review.ONE_STAR_REVIEW, new Date(89, 3, 30,
				17, 22, 22));
		OBJECT6.rate(USER3, Review.ONE_STAR_REVIEW, new Date(90, 3, 30,
				17, 22, 22));
		OBJECT7.rate(USER3, Review.ONE_STAR_REVIEW, new Date(91, 3, 30,
				17, 22, 22));
		OBJECT8.rate(USER3, Review.ONE_STAR_REVIEW, new Date(92, 3, 30,
				17, 22, 22));

		_group3 = new ReviewerGroup(new LinkedHashSet<User>() {
			{
				add(USER1);
				add(USER2);
				add(USER3);
			}
		}, new LinkedHashSet<RateableObject>() {
			{
				add(OBJECT6);
				add(OBJECT7);
				add(OBJECT8);
			}
		});

		_reviewerGroups = new LinkedHashSet<ReviewerGroup>() {
			{
				add(_group1);
				add(_group2);
				add(_group3);
			}
		};
	}

	@Test
	public void test() {
		Map<ReviewerGroup, Double> calculatedEarlyTimeFrameSpamScore = EarlyTimeFrameSpamScoreCalculator
				.calculateEarlyTimeFrameSpamScore(_reviewerGroups);
		// Gruppe 1 msste einen SpamScore von 1.0 erhalten haben, da alle
		// Bewertungen ind er gleichen Millisekunde der frhest mglichen
		// Bewertung stattfinden.
		assertTrue(1.0 == calculatedEarlyTimeFrameSpamScore.get(_group1));
		// Gruppe 2 msste einen SpamScore von 0.5 erhalten haben, da im
		// schlechtesten Fall die letzte Bewertungen 1.5 Stunden nach der
		// frhest mglichen Bewertung liegen.
		assertTrue(0.5 == calculatedEarlyTimeFrameSpamScore.get(_group2));
		// Gruppe 1 msste einen SpamScore von 0.0 erhalten haben, da alle
		// letzten
		// Bewertungen ber 1 Jahr nach der frhest mglichen Bewertung liegen.
		assertTrue(0.0 == calculatedEarlyTimeFrameSpamScore.get(_group3));
	}

}
