/**
 * Bachelorarbeit: Crowdsourcing- Systeme Manipulation und Resistenz
 * von Jens Bothur
 */
package jens.bothur.occt.automatons.security_framework.group_calculators;

import static org.junit.Assert.assertTrue;

import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

import jens.bothur.occt.domainobjects.RateableObject;
import jens.bothur.occt.domainobjects.ReviewerGroup;
import jens.bothur.occt.domainobjects.User;
import jens.bothur.occt.domainvalues.Review;

import org.junit.Before;
import org.junit.Test;

/**
 * Test fr die Klasse: {@link GroupSizeRatioSpamScoreCalculator}.
 * 
 * @author Jens Bothur
 */
public class GroupSizeRatioSpamScoreCalculatorTest {

	private Set<ReviewerGroup> _reviewerGroups;

	private ReviewerGroup _group1;

	private final User USER1 = new User("1");
	private final User USER2 = new User("2");
	private final User USER3 = new User("3");
	private final User USER4 = new User("4");
	private final User USER5 = new User("5");
	private final User USER6 = new User("6");
	private final User USER7 = new User("7");
	private final User USER8 = new User("8");

	private final RateableObject OBJECT1 = new RateableObject();
	private final RateableObject OBJECT2 = new RateableObject();
	private final RateableObject OBJECT3 = new RateableObject();

	/**
	 * @throws java.lang.Exception
	 */
	@SuppressWarnings({ "serial" })
	@Before
	public void setUp() throws Exception {

		OBJECT1.rate(USER1, Review.ONE_STAR_REVIEW, new Date());
		OBJECT2.rate(USER1, Review.ONE_STAR_REVIEW, new Date());
		OBJECT3.rate(USER1, Review.ONE_STAR_REVIEW, new Date());
		OBJECT1.rate(USER2, Review.ONE_STAR_REVIEW, new Date());
		OBJECT2.rate(USER2, Review.ONE_STAR_REVIEW, new Date());
		OBJECT3.rate(USER2, Review.ONE_STAR_REVIEW, new Date());

		_group1 = new ReviewerGroup(new LinkedHashSet<User>() {
			{
				add(USER1);
				add(USER2);
			}
		}, new LinkedHashSet<RateableObject>() {
			{
				add(OBJECT1);
				add(OBJECT2);
				add(OBJECT3);
			}
		});

		_reviewerGroups = new LinkedHashSet<ReviewerGroup>() {
			{
				add(_group1);
			}
		};
	}

	@Test
	public void testCalculate() {
		Map<ReviewerGroup, Double> calculateGroupSizeRatio = GroupSizeRatioSpamScoreCalculator
				.calculateGroupSizeRatioSpamScore(_reviewerGroups);
		// zu Beginn sollte Gruppe 1 einen Score von 1 bekommen, da sie alleine
		// alle objekte bewertet hat.
		assertTrue(1.0 == calculateGroupSizeRatio.get(_group1));

		OBJECT1.rate(USER3, Review.ONE_STAR_REVIEW, new Date());
		OBJECT1.rate(USER4, Review.ONE_STAR_REVIEW, new Date());
		OBJECT1.rate(USER5, Review.ONE_STAR_REVIEW, new Date());
		OBJECT1.rate(USER6, Review.ONE_STAR_REVIEW, new Date());
		OBJECT1.rate(USER7, Review.ONE_STAR_REVIEW, new Date());
		OBJECT1.rate(USER8, Review.ONE_STAR_REVIEW, new Date());
		// 0.66
		calculateGroupSizeRatio = GroupSizeRatioSpamScoreCalculator
				.calculateGroupSizeRatioSpamScore(_reviewerGroups);
		assertTrue(0.75 == calculateGroupSizeRatio.get(_group1));

		OBJECT2.rate(USER3, Review.ONE_STAR_REVIEW, new Date());
		OBJECT2.rate(USER4, Review.ONE_STAR_REVIEW, new Date());
		OBJECT2.rate(USER5, Review.ONE_STAR_REVIEW, new Date());
		OBJECT2.rate(USER6, Review.ONE_STAR_REVIEW, new Date());
		OBJECT2.rate(USER7, Review.ONE_STAR_REVIEW, new Date());
		OBJECT2.rate(USER8, Review.ONE_STAR_REVIEW, new Date());
		// 0.5
		calculateGroupSizeRatio = GroupSizeRatioSpamScoreCalculator
				.calculateGroupSizeRatioSpamScore(_reviewerGroups);
		assertTrue(0.5 == calculateGroupSizeRatio.get(_group1));

		OBJECT3.rate(USER3, Review.ONE_STAR_REVIEW, new Date());
		OBJECT3.rate(USER4, Review.ONE_STAR_REVIEW, new Date());
		OBJECT3.rate(USER5, Review.ONE_STAR_REVIEW, new Date());
		OBJECT3.rate(USER6, Review.ONE_STAR_REVIEW, new Date());
		OBJECT3.rate(USER7, Review.ONE_STAR_REVIEW, new Date());
		OBJECT3.rate(USER8, Review.ONE_STAR_REVIEW, new Date());
		// 0.25
		calculateGroupSizeRatio = GroupSizeRatioSpamScoreCalculator
				.calculateGroupSizeRatioSpamScore(_reviewerGroups);
		assertTrue(0.25 == calculateGroupSizeRatio.get(_group1));

	}

}
