/**
 * Bachelorarbeit: Crowdsourcing- Systeme Manipulation und Resistenz
 * von Jens Bothur
 */
package jens.bothur.occt.automatons.security_framework.single_calculators;

import static org.junit.Assert.assertTrue;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

import jens.bothur.occt.automatons.security_framework.single_calculators.RatingSpamScoreCalculator;
import jens.bothur.occt.domainobjects.GroupOfRateableObjects;
import jens.bothur.occt.domainobjects.RateableObject;
import jens.bothur.occt.domainobjects.User;
import jens.bothur.occt.domainvalues.Review;

import org.junit.Before;
import org.junit.Test;

/**
 * Test fr die Klasse: {@link RatingSpamScoreCalculator}.
 * 
 * @author Jens Bothur
 */
public class RatingSpamScoreCalculatorTest {

	private final User _user1 = new User("a");
	private final User _user2 = new User("b");
	private final User _user3 = new User("c");
	private final User _user4 = new User("d");

	private Collection<User> _users;

	private final RateableObject _object1 = new RateableObject();
	private final RateableObject _object2 = new RateableObject();
	private final RateableObject _object3 = new RateableObject();
	private final RateableObject _object4 = new RateableObject();
	private final RateableObject _object5 = new RateableObject();

	private GroupOfRateableObjects _group1;
	private GroupOfRateableObjects _group2;

	private Set<GroupOfRateableObjects> _groups;

	/**
	 * @throws java.lang.Exception
	 */
	@SuppressWarnings("serial")
	@Before
	public void setUp() throws Exception {
		_users = new LinkedHashSet<User>() {
			{
				add(_user1);
				add(_user2);
				add(_user3);
				add(_user4);
			}
		};
		_object1.rate(_user1, Review.ONE_STAR_REVIEW, new Date());
		_object2.rate(_user1, Review.TWO_STAR_REVIEW, new Date());
		_object3.rate(_user1, Review.ONE_STAR_REVIEW, new Date());
		_object4.rate(_user1, Review.ONE_STAR_REVIEW, new Date());
		_object5.rate(_user1, Review.ONE_STAR_REVIEW, new Date());

		_object1.rate(_user2, Review.FIVE_STAR_REVIEW, new Date());
		_object2.rate(_user2, Review.FIVE_STAR_REVIEW, new Date());
		_object3.rate(_user2, Review.FIVE_STAR_REVIEW, new Date());

		_object1.rate(_user3, Review.ONE_STAR_REVIEW, new Date());
		_object2.rate(_user3, Review.TWO_STAR_REVIEW, new Date());
		_object3.rate(_user3, Review.THREE_STAR_REVIEW, new Date());
		_object4.rate(_user3, Review.FOUR_STAR_REVIEW, new Date());
		_object5.rate(_user3, Review.FIVE_STAR_REVIEW, new Date());

		_group1 = new GroupOfRateableObjects(
				new LinkedHashSet<RateableObject>() {
					{
						add(_object1);
						add(_object2);
						add(_object3);
					}
				}, new LinkedHashSet<User>() {
					{
						add(_user1);
						add(_user2);
						add(_user3);
					}
				});
		_group2 = new GroupOfRateableObjects(
				new LinkedHashSet<RateableObject>() {
					{
						add(_object4);
						add(_object5);
					}
				}, new LinkedHashSet<User>() {
					{
						add(_user1);
						add(_user3);
					}
				});

		_groups = new LinkedHashSet<GroupOfRateableObjects>() {
			{
				add(_group1);
				add(_group2);
			}
		};

	}

	@Test
	public void testcalculateRatingSpamScore() {
		Map<User, Double> spamScore = RatingSpamScoreCalculator
				.calculateRatingSpamScore(_users, _groups);
		// user1 sollte einen spam score von 1 haben
		assertTrue(1 == spamScore.get(_user1));
		// user2 sollte einen spam score von 1 haben
		assertTrue(1 == spamScore.get(_user2));
		// user3 sollte einen kleineren spam score haben als 1 und 2
		assertTrue(spamScore.get(_user3) < spamScore.get(_user1));
		assertTrue(spamScore.get(_user3) < spamScore.get(_user2));
		// user4 sollte einen spam score von 0 haben
		assertTrue(0 == spamScore.get(_user4));
	}

	@Test
	public void testCalculateAndInduceObjectSpecificRatingSpamScore() {
		// diese private Methode wird per Reflection getestet
		try {
			Field field = RatingSpamScoreCalculator.class
					.getDeclaredField("_result");
			field.setAccessible(true);
			Map<User, Double> result = new LinkedHashMap<User, Double>();
			result.put(_user1, 0.0);
			result.put(_user2, 0.0);
			result.put(_user3, 0.0);
			result.put(_user4, 0.0);
			field.set(null, result);

			Method calculateAndInduceObjectSpecificRatingSpamScores = RatingSpamScoreCalculator.class
					.getDeclaredMethod(
							"calculateAndInduceObjectSpecificRatingSpamScores",
							GroupOfRateableObjects.class);
			calculateAndInduceObjectSpecificRatingSpamScores
					.setAccessible(true);

			calculateAndInduceObjectSpecificRatingSpamScores.invoke(null,
					_group1);
			// die reihenfolge der user sollte 2,1,3,4 sein
			Double double1 = result.get(_user1);
			Double double2 = result.get(_user2);
			Double double3 = result.get(_user3);
			Double double4 = result.get(_user4);
			assertTrue(1 == double2);
			assertTrue(double2 > double1);
			assertTrue(double1 > double3);
			assertTrue(double3 > double4);
			assertTrue(0 == double4);

			// und die zweite gruppe
			result.put(_user1, 0.0);
			result.put(_user2, 0.0);
			result.put(_user3, 0.0);
			result.put(_user4, 0.0);

			calculateAndInduceObjectSpecificRatingSpamScores.invoke(null,
					_group2);

			// die reihenfolge der user sollte 1,3,2=4 sein
			double1 = result.get(_user1);
			double2 = result.get(_user2);
			double3 = result.get(_user3);
			double4 = result.get(_user4);
			assertTrue(1 == double1);
			assertTrue(double1 > double3);
			assertTrue(double3 > double2);
			assertTrue(0 == double2);
			assertTrue(0 == double4);

		} catch (SecurityException e) {
			assertTrue(false);
		} catch (NoSuchMethodException e) {
			assertTrue(false);
		} catch (NoSuchFieldException e) {
			assertTrue(false);
		} catch (IllegalArgumentException e) {
			e.printStackTrace();
			assertTrue(false);
		} catch (IllegalAccessException e) {
			assertTrue(false);
		} catch (InvocationTargetException e) {
			e.printStackTrace();
			assertTrue(false);
		}
	}
}
