/**
 * Bachelorarbeit: Crowdsourcing- Systeme Manipulation und Resistenz
 * von Jens Bothur
 */
package jens.bothur.occt.domainobjects;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Set;

import jens.bothur.occt.domainvalues.Review;

import org.junit.Before;
import org.junit.Test;

/**
 * Test fr die Klasse: {@link GroupOfRateableObjects}.
 * 
 * @author Jens Bothur
 */
public class GroupOfRatebaleObjectsTest {

	private GroupOfRateableObjects _instance1;
	private GroupOfRateableObjects _instance2;

	private final RateableObject _object1 = new RateableObject();
	private final RateableObject _object2 = new RateableObject();
	private final RateableObject _object3 = new RateableObject();
	private final RateableObject _object4 = new RateableObject();
	private final RateableObject _object5 = new RateableObject();

	private final User _user1 = new User("a");
	private final User _user2 = new User("b");
	private final User _user3 = new User("c");
	private final User _user4 = new User("a");

	/**
	 * @throws java.lang.Exception
	 */
	@SuppressWarnings("serial")
	@Before
	public void setUp() throws Exception {
		_object1.rate(_user1, Review.ONE_STAR_REVIEW, new Date());
		_object1.rate(_user2, Review.ONE_STAR_REVIEW, new Date());
		_object2.rate(_user1, Review.ONE_STAR_REVIEW, new Date());
		_object2.rate(_user2, Review.ONE_STAR_REVIEW, new Date());
		_object2.rate(_user3, Review.ONE_STAR_REVIEW, new Date());
		_object3.rate(_user1, Review.ONE_STAR_REVIEW, new Date());
		_object3.rate(_user3, Review.ONE_STAR_REVIEW, new Date());

		_instance1 = new GroupOfRateableObjects(
				new LinkedHashSet<RateableObject>() {
					{
						add(_object1);
						add(_object2);
						add(_object3);
					}
				}, new LinkedHashSet<User>() {
					{
						add(_user1);
						add(_user2);
						add(_user3);
					}
				});

		_object4.rate(_user2, Review.ONE_STAR_REVIEW, new Date());
		_object4.rate(_user3, Review.ONE_STAR_REVIEW, new Date());
		_object4.rate(_user4, Review.ONE_STAR_REVIEW, new Date());
		_object5.rate(_user2, Review.ONE_STAR_REVIEW, new Date());
		_object5.rate(_user3, Review.ONE_STAR_REVIEW, new Date());
		_object5.rate(_user4, Review.ONE_STAR_REVIEW, new Date());

		_instance2 = new GroupOfRateableObjects(
				new LinkedHashSet<RateableObject>() {
					{
						add(_object4);
						add(_object5);
					}
				}, new LinkedHashSet<User>() {
					{
						add(_user2);
						add(_user3);
						add(_user4);
					}
				});
	}

	@Test
	public void testToString() {
		assertTrue(_instance1.toString() instanceof String);
		assertNotNull(_instance1.toString());
	}

	@SuppressWarnings("serial")
	@Test
	public void testConstructorAsserts() {
		// teste zu wenig members.
		boolean exception = false;
		try {
			new GroupOfRateableObjects(new LinkedHashSet<RateableObject>() {
				{
					add(_object4);
				}
			}, new LinkedHashSet<User>() {
				{
					add(_user2);
					add(_user3);
					add(_user4);
				}
			});
		} catch (AssertionError e) {
			exception = true;
		}
		assertTrue(
				"There should have been an AssertionError, because constructor was called with illegal parameters.",
				exception);

		// teste zu wenig bewertungen von einem benutzer.
		exception = false;
		try {
			new GroupOfRateableObjects(new LinkedHashSet<RateableObject>() {
				{
					add(_object4);
					add(_object5);
				}
			}, new LinkedHashSet<User>() {
				{
					add(_user1);
					add(_user2);
					add(_user3);
					add(_user4);
				}
			});
		} catch (AssertionError e) {
			exception = true;
		}
		assertTrue(
				"There should have been an AssertionError, because constructor was called with illegal parameters.",
				exception);

	}

	@SuppressWarnings("serial")
	@Test
	public void testHashcodeAndEquals() {
		assertEquals(_instance1, _instance1);
		assertEquals(_instance2, _instance2);
		assertFalse(_instance1.equals(_instance2));
		assertFalse(_instance1.equals(null));
		assertFalse(_instance1.equals("Hallo"));
		assertFalse(_instance1.equals(new GroupOfRateableObjects(
				new LinkedHashSet<RateableObject>() {
					{
						add(_object1);
						add(_object2);
						add(_object3);
					}
				}, new LinkedHashSet<User>() {
					{
						add(_user1);
						add(_user2);
					}
				})));

		assertTrue(_instance1.hashCode() == _instance1.hashCode());
		assertTrue(_instance2.hashCode() == _instance2.hashCode());

		_instance2 = new GroupOfRateableObjects(
				new LinkedHashSet<RateableObject>() {
					{
						add(_object1);
						add(_object2);
						add(_object3);
					}
				}, new LinkedHashSet<User>() {
					{
						add(_user1);
						add(_user2);
						add(_user3);
					}
				});

		assertEquals(_instance1, _instance2);
		assertTrue(_instance1.hashCode() == _instance2.hashCode());

	}

	@Test
	public void testGetMembets() {
		Set<RateableObject> members = _instance1.getMembers();

		assertTrue(members.contains(_object1));
		assertTrue(members.contains(_object2));
		assertTrue(members.contains(_object3));
		assertFalse(members.contains(_object4));
		assertFalse(members.contains(_object5));

		members = _instance2.getMembers();

		assertFalse(members.contains(_object1));
		assertFalse(members.contains(_object2));
		assertFalse(members.contains(_object3));
		assertTrue(members.contains(_object4));
		assertTrue(members.contains(_object5));
	}

	@Test
	public void testGetRates() {
		Set<User> raters = _instance1.getRaters();

		assertTrue(raters.contains(_user1));
		assertTrue(raters.contains(_user2));
		assertTrue(raters.contains(_user3));
		assertFalse(raters.contains(_user4));

		raters = _instance2.getRaters();

		assertFalse(raters.contains(_user1));
		assertTrue(raters.contains(_user2));
		assertTrue(raters.contains(_user3));
		assertTrue(raters.contains(_user4));
	}

}
