/**
 * Bachelorarbeit: Crowdsourcing- Systeme Manipulation und Resistenz
 * von Jens Bothur
 */
package jens.bothur.occt.domainobjects;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Set;

import jens.bothur.occt.domainvalues.Review;

import org.junit.Before;
import org.junit.Test;

/**
 * Test fr die Klasse: {@link ReviewerGroup}.
 * 
 * @author Jens Bothur
 */
public class ReviewerGroupTest {

	private ReviewerGroup _instance1;
	private ReviewerGroup _instance2;

	private final User USER1 = new User("1");
	private final User USER2 = new User("2");
	private final User USER3 = new User("3");

	private final RateableObject OBJECT1 = new RateableObject();
	private final RateableObject OBJECT2 = new RateableObject();
	private final RateableObject OBJECT3 = new RateableObject();
	private final RateableObject OBJECT4 = new RateableObject();
	private final RateableObject OBJECT5 = new RateableObject();

	/**
	 * @throws java.lang.Exception
	 */
	@SuppressWarnings("serial")
	@Before
	public void setUp() throws Exception {

		OBJECT1.rate(USER1, Review.ONE_STAR_REVIEW, new Date());
		OBJECT2.rate(USER1, Review.ONE_STAR_REVIEW, new Date());
		OBJECT3.rate(USER1, Review.ONE_STAR_REVIEW, new Date());
		OBJECT1.rate(USER2, Review.ONE_STAR_REVIEW, new Date());
		OBJECT2.rate(USER2, Review.ONE_STAR_REVIEW, new Date());
		OBJECT3.rate(USER2, Review.ONE_STAR_REVIEW, new Date());

		_instance1 = new ReviewerGroup(new LinkedHashSet<User>() {
			{
				add(USER1);
				add(USER2);
			}
		}, new LinkedHashSet<RateableObject>() {
			{
				add(OBJECT1);
				add(OBJECT2);
				add(OBJECT3);
			}
		});

		OBJECT3.rate(USER1, Review.ONE_STAR_REVIEW, new Date());
		OBJECT4.rate(USER1, Review.ONE_STAR_REVIEW, new Date());
		OBJECT5.rate(USER1, Review.ONE_STAR_REVIEW, new Date());
		OBJECT3.rate(USER3, Review.ONE_STAR_REVIEW, new Date());
		OBJECT4.rate(USER3, Review.ONE_STAR_REVIEW, new Date());
		OBJECT5.rate(USER3, Review.ONE_STAR_REVIEW, new Date());

		_instance2 = new ReviewerGroup(new LinkedHashSet<User>() {
			{
				add(USER1);
				add(USER3);
			}
		}, new LinkedHashSet<RateableObject>() {
			{
				add(OBJECT3);
				add(OBJECT4);
				add(OBJECT5);
			}
		});
	}

	@SuppressWarnings("serial")
	@Test
	public void testConstructorAsserts() {
		// teste zu wenig mitglieder
		boolean exception = false;
		try {
			new ReviewerGroup(new LinkedHashSet<User>() {
				{
					add(USER1);
				}
			}, new LinkedHashSet<RateableObject>() {
				{
					add(OBJECT3);
					add(OBJECT4);
					add(OBJECT5);
				}
			});
		} catch (AssertionError e) {
			exception = true;
		}
		assertTrue(
				"There should have been an AssertionError, because constructor was called with illegal parameters.",
				exception);

		// teste zu kleine Menge von objekten.
		exception = false;
		try {
			new ReviewerGroup(new LinkedHashSet<User>() {
				{
					add(USER1);
					add(USER3);
				}
			}, new LinkedHashSet<RateableObject>() {
				{
					add(OBJECT3);
					add(OBJECT4);
				}
			});
		} catch (AssertionError e) {
			exception = true;
		}
		assertTrue(
				"There should have been an AssertionError, because constructor was called with illegal parameters.",
				exception);

		// teste das alle benutzer alle objekte auch bewertet haben
		exception = false;
		try {
			new ReviewerGroup(new LinkedHashSet<User>() {
				{
					add(USER1);
					add(USER2);
				}
			}, new LinkedHashSet<RateableObject>() {
				{
					add(OBJECT3);
					add(OBJECT4);
					add(OBJECT5);
				}
			});
		} catch (AssertionError e) {
			exception = true;
		}
		assertTrue(
				"There should have been an AssertionError, because constructor was called with illegal parameters.",
				exception);
	}

	@Test
	public void testToString() {
		assertTrue(_instance1.toString() instanceof String);
		assertNotNull(_instance1.toString());
	}

	@SuppressWarnings("serial")
	@Test
	public void testHashCodeAndEquals() {

		assertEquals(_instance1, _instance1);
		assertEquals(_instance2, _instance2);
		assertFalse(_instance1.equals(_instance2));
		assertFalse(_instance1.equals(null));
		assertFalse(_instance1.equals("Hallo"));

		assertTrue(_instance1.hashCode() == _instance1.hashCode());
		assertTrue(_instance2.hashCode() == _instance2.hashCode());

		_instance2 = new ReviewerGroup(new LinkedHashSet<User>() {
			{
				add(USER1);
				add(USER2);
			}
		}, new LinkedHashSet<RateableObject>() {
			{
				add(OBJECT1);
				add(OBJECT2);
				add(OBJECT3);
			}
		});

		assertEquals(_instance1, _instance2);
		assertTrue(_instance1.hashCode() == _instance2.hashCode());

	}

	@Test
	public void testGetMembers() {
		Set<User> members = _instance1.getMembers();

		assertTrue(members.contains(USER1));
		assertTrue(members.contains(USER2));
		assertFalse(members.contains(USER3));

		members = _instance2.getMembers();

		assertTrue(members.contains(USER1));
		assertFalse(members.contains(USER2));
		assertTrue(members.contains(USER3));
	}

	@Test
	public void testGetCollaboreatedObjects() {
		Set<RateableObject> collaboratedObjects = _instance1
				.getCollaboratedObjects();

		assertTrue(collaboratedObjects.contains(OBJECT1));
		assertTrue(collaboratedObjects.contains(OBJECT2));
		assertTrue(collaboratedObjects.contains(OBJECT3));
		assertFalse(collaboratedObjects.contains(OBJECT4));
		assertFalse(collaboratedObjects.contains(OBJECT5));

		collaboratedObjects = _instance2.getCollaboratedObjects();

		assertFalse(collaboratedObjects.contains(OBJECT1));
		assertFalse(collaboratedObjects.contains(OBJECT2));
		assertTrue(collaboratedObjects.contains(OBJECT3));
		assertTrue(collaboratedObjects.contains(OBJECT4));
		assertTrue(collaboratedObjects.contains(OBJECT5));
	}

}
