/**
 * Bachelorarbeit: Crowdsourcing- Systeme Manipulation und Resistenz
 * von Jens Bothur
 */
package jens.bothur.occt.domainvalues;

import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

import org.junit.Before;
import org.junit.Test;

/**
 * Test fr die Klasse: {@link Review}
 * 
 * @author Jens Bothur
 */
public class ReviewTest {

	/**
	 * @throws java.lang.Exception
	 */
	@Before
	public void setUp() throws Exception {
	}

	@Test
	public void testAllRatingsAreThere() {
		assertNotNull(Review.ONE_STAR_REVIEW);
		assertNotNull(Review.TWO_STAR_REVIEW);
		assertNotNull(Review.THREE_STAR_REVIEW);
		assertNotNull(Review.FOUR_STAR_REVIEW);
		assertNotNull(Review.FIVE_STAR_REVIEW);
	}

	@Test
	public void testAllRatingsAreRight() {
		assertTrue(1 == Review.ONE_STAR_REVIEW.getRating());
		assertTrue(2 == Review.TWO_STAR_REVIEW.getRating());
		assertTrue(3 == Review.THREE_STAR_REVIEW.getRating());
		assertTrue(4 == Review.FOUR_STAR_REVIEW.getRating());
		assertTrue(5 == Review.FIVE_STAR_REVIEW.getRating());
	}

	@Test
	public void testAllNormalizedRatingsAreRight() {
		assertTrue(0.0 == Review.ONE_STAR_REVIEW.getNormalizedRating());
		assertTrue(0.25 == Review.TWO_STAR_REVIEW.getNormalizedRating());
		assertTrue(0.5 == Review.THREE_STAR_REVIEW.getNormalizedRating());
		assertTrue(0.75 == Review.FOUR_STAR_REVIEW.getNormalizedRating());
		assertTrue(1.0 == Review.FIVE_STAR_REVIEW.getNormalizedRating());
	}

	@Test
	public void testPrivateConstructor() {
		boolean exception = false;

		try {
			Constructor<Review> reviewPrivateConstructor = Review.class
					.getDeclaredConstructor(int.class);

			reviewPrivateConstructor.setAccessible(true);

			reviewPrivateConstructor.newInstance(6);

		} catch (SecurityException e) {
			e.printStackTrace();
			assertTrue(false);
		} catch (NoSuchMethodException e) {
			e.printStackTrace();
			assertTrue(false);
		} catch (InstantiationException e) {
			e.printStackTrace();
			assertTrue(false);
		} catch (IllegalAccessException e) {
			e.printStackTrace();
			assertTrue(false);
		} catch (InvocationTargetException e) {
			exception = true;
		} catch (IllegalArgumentException e) {
			exception = true;
		}

		assertTrue("There should have been an IllegalArgumentException",
				exception);

	}

}
