/**
 * Bachelorarbeit: Crowdsourcing- Systeme Manipulation und Resistenz
 * von Jens Bothur
 */
package jens.bothur.occt.services;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNull;
import static org.junit.Assert.assertTrue;

import java.util.Random;

import jens.bothur.occt.domainobjects.RateableObject;

import org.junit.Before;
import org.junit.Test;

/**
 * Test fr die Klasse: {@link DummyRateableObjectService}
 * 
 * @author Jens Bothur
 */
public class DummyRateableObjectServiceTest {

	private DummyRateableObjectService _instance;

	private RateableObject _object1;
	private RateableObject _object2;

	/**
	 * @throws java.lang.Exception
	 */
	@Before
	public void setUp() throws Exception {
		_instance = new DummyRateableObjectService();

		_object1 = new RateableObject();
		_object2 = new RateableObject();
	}

	@Test
	public void testInitalState() {
		assertTrue(_instance.getAllRateableObjects().isEmpty());

		Random random = new Random(232322);
		for (int i = 0; i < 100; i++) {
			assertNull(_instance.getRateableObject(random.nextLong()));
		}
		assertNull(_instance.getRateableObject(Long.MAX_VALUE));
		assertNull(_instance.getRateableObject(Long.MIN_VALUE));
	}

	@Test
	public void testBasicFunctionsWithRegisterGetAndGetAll() {
		_instance.registerRateableObject(_object1);
		assertTrue(1 == _instance.getAllRateableObjects().size());
		assertTrue(_instance.getAllRateableObjects().contains(_object1));
		assertEquals(_object1, _instance.getRateableObject(_object1.getID()));

		_instance.registerRateableObject(_object1);
		assertTrue(1 == _instance.getAllRateableObjects().size());
		assertTrue(_instance.getAllRateableObjects().contains(_object1));
		assertEquals(_object1, _instance.getRateableObject(_object1.getID()));

		_instance.registerRateableObject(_object2);
		assertTrue(2 == _instance.getAllRateableObjects().size());
		assertTrue(_instance.getAllRateableObjects().contains(_object1));
		assertTrue(_instance.getAllRateableObjects().contains(_object2));
		assertEquals(_object1, _instance.getRateableObject(_object1.getID()));
		assertEquals(_object2, _instance.getRateableObject(_object2.getID()));

		_instance.registerRateableObject(_object1);
		_instance.registerRateableObject(_object2);
		assertTrue(2 == _instance.getAllRateableObjects().size());
		assertTrue(_instance.getAllRateableObjects().contains(_object1));
		assertTrue(_instance.getAllRateableObjects().contains(_object2));
		assertEquals(_object1, _instance.getRateableObject(_object1.getID()));
		assertEquals(_object2, _instance.getRateableObject(_object2.getID()));

	}

}
