package edu.ubb.scp.gui;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

import edu.ubb.scp.dao.BaseDAO;
import edu.ubb.scp.dao.DAOFactory;
import edu.ubb.scp.dao.jdbc.JdbcConnection;
import edu.ubb.scp.model.Customer;
import edu.ubb.scp.model.Model;
import edu.ubb.scp.model.Table;
/**
 * 
 * @author Sandor
 *
 */
public abstract class BaseGui extends JFrame {
	
	protected ArrayList<Integer> productCart = new ArrayList<Integer>();
	protected ArrayList<Integer> gameCart = new ArrayList<Integer>();
	
	protected Customer currentCustomer;
	
	protected ActionListener menuListener;
	protected JPanel contentPane = null;
	protected JMenuBar menuBar = null;
	protected JScrollPane tablePane = new JScrollPane();
	protected JPanel buttonPane = new JPanel();
	protected JTable table;
	protected JComboBox tables;
	public BaseGui() {
		
		super("Self Checkout Pub");
		
		setSize(850,650);
		
		setDefaultCloseOperation(EXIT_ON_CLOSE);
		
		contentPane = new JPanel(new BorderLayout(0, 10));
		contentPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
		
		buttonPane = new JPanel();
		buttonPane.setLayout(new FlowLayout());
		buttonPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
		
		menuBar = new JMenuBar();
		setJMenuBar(menuBar);
		//initMenuBar();
		
		contentPane.add(tablePane, BorderLayout.CENTER);
		contentPane.add(buttonPane, BorderLayout.NORTH);
		tablePane.setBorder(BorderFactory.createEtchedBorder());
		setContentPane(contentPane);	
		
		//initOrderProduct();
		
		//setVisible(true);
	}
	
	protected JMenuItem createMenuItem(JMenu menu, String label, int mnemonicKey,
			String actionCommand) {
		JMenuItem menuItem = new JMenuItem(label);

		if (mnemonicKey > 0) {
			menuItem.setMnemonic(mnemonicKey);
		}

		if (actionCommand.length() > 0) {
			menuItem.setActionCommand(actionCommand);
		}
		menuItem.addActionListener(menuListener);
		menu.add(menuItem);

		return menuItem;
	}
	
	protected void setCustomer(Customer customer) {
		currentCustomer = customer;
		updateCustomer();
	}
	
	protected abstract void updateCustomer();
	
	
	
}
