package edu.ubb.scp.gui;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;

import edu.ubb.scp.dao.BaseDAO;
import edu.ubb.scp.dao.DAOFactory;
import edu.ubb.scp.model.Game;
import edu.ubb.scp.model.Product;

public class ComplexInserter extends JDialog {

	private JPanel contentPane;
	private JTable table1;
	private JTable table2;
	private JTable table3;
	private JScrollPane tablePane1;
	private JScrollPane tablePane2;
	private JScrollPane tablePane3;
	private JPanel tablePane = new JPanel(new FlowLayout());
	private JScrollPane tableScrollPane = new JScrollPane();
	private JPanel buttonPane = new JPanel(new FlowLayout());
	private ManageGui parent;

	private JButton insertButton = new JButton("Insert");

	private JLabel nameLabel = new JLabel("Name: ");
	private JLabel priceLabel = new JLabel("Price: ");
	private JLabel stockLabel = new JLabel("Stock: ");

	private JTextField nameField = new JTextField(25);
	private JTextField stockField = new JTextField(4);
	private JTextField priceField = new JTextField(4);

	private DAOFactory df = DAOFactory.getInstance();
	private BaseDAO bd = df.getBaseDAO();

	public ComplexInserter(ManageGui parent, String type) {
		super(parent, true);
		this.parent = parent;
		setSize(980, 540);
		contentPane = new JPanel(new BorderLayout());
		contentPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));

		tablePane1 = new JScrollPane();
		tablePane1.setBorder(BorderFactory.createEtchedBorder());
		tablePane2 = new JScrollPane();
		tablePane2.setBorder(BorderFactory.createEtchedBorder());
		tablePane3 = new JScrollPane();
		tablePane3.setBorder(BorderFactory.createEtchedBorder());
		

		if (type.equals("Game")) {
			initGame();
		} else if (type.equals("Product")) {
			initProduct();
		}

		tablePane1.setViewportView(table1);
		tablePane2.setViewportView(table2);
		tablePane3.setViewportView(table3);

		tablePane.add(tablePane1);
		tablePane.add(tablePane2);
		tablePane.add(tablePane3);
		tableScrollPane.setViewportView(tablePane);
		contentPane.add(tableScrollPane, BorderLayout.CENTER);
		contentPane.add(buttonPane, BorderLayout.NORTH);

		// setResizable(false);
		setContentPane(contentPane);
		setDefaultCloseOperation(DISPOSE_ON_CLOSE);
		setVisible(true);
	}

	private void initProduct() {

		table1 = TableLoader.getProductType();
		table2 = TableLoader.getProductBrand();
		table3 = TableLoader.getProviderSimple();
		//tablePane3.setViewportView(table3);
		tablePane.add(table3);
		buttonPane.add(nameLabel);
		buttonPane.add(nameField);
		buttonPane.add(priceLabel);
		buttonPane.add(priceField);
		buttonPane.add(stockLabel);
		buttonPane.add(stockField);
		buttonPane.add(insertButton);

		insertButton.addActionListener(new ActionListener() {

			@Override
			public void actionPerformed(ActionEvent arg0) {
				try {
					Product p = new Product(nameField.getText(),
							Integer.parseInt(stockField.getText()), 
							(Integer)table3.getValueAt(table3.getSelectedRow(), 0),
							(Integer)table1.getValueAt(table1.getSelectedRow(), 0), 
							(Integer)table2.getValueAt(table2.getSelectedRow(), 0), 
							Float.parseFloat(priceField.getText()));
					bd.insert(p);
					parent.initManageProduct();
										
				}
				catch (NumberFormatException f) {
					showError("Number format error");
				}
				catch (Exception e) {
					
				}

			}
		});

	}

	private void initGame() {
		table1 = TableLoader.getGameType();
		table2 = TableLoader.getGameBrand();

		buttonPane.add(nameLabel);
		buttonPane.add(nameField);
		buttonPane.add(insertButton);

		insertButton.addActionListener(new ActionListener() {

			@Override
			public void actionPerformed(ActionEvent arg0) {
				// TODO Auto-generated method stub
				try {
					Game g = new Game(nameField.getText(), (Integer) table1
							.getValueAt(table1.getSelectedRow(), 0),
							(Integer) table2.getValueAt(
									table2.getSelectedRow(), 0));
					bd.insert(g);
					parent.initManageGame();


				} catch (Exception e) {
					showError("You must select brand and type");
				}
			}
		});

	}

	private void showError(String s) {

		JOptionPane.showMessageDialog(this, 
				s, "Error", JOptionPane.ERROR_MESSAGE);

	}

}
