package edu.ubb.scp.gui;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.ArrayList;

import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

import edu.ubb.scp.dao.BaseDAO;
import edu.ubb.scp.dao.DAOFactory;
import edu.ubb.scp.exception.UnsafeException;
import edu.ubb.scp.model.GameOrder;
import edu.ubb.scp.model.Model;
import edu.ubb.scp.model.Order;
import edu.ubb.scp.model.Table;

public class CustomerGui extends BaseGui {
	
	private int tableNumber = 0;
	private DAOFactory df = DAOFactory.getInstance();
	private BaseDAO bd = df.getBaseDAO();
	private JLabel customerLabel = new JLabel("Current customer: ");
	private JTextField quantity;
	public CustomerGui() {
		initOrderProduct();
		initMenuBar();
		setVisible(true);
	}
	
	private void initMenuListener() {
		menuListener = new ActionListener() {
			
			@Override
			public void actionPerformed(ActionEvent e) {
				
				String comm = e.getActionCommand();
				
				if (comm == "Order drinks") {
					System.out.println("Drinks");
					initOrderProduct();
				}
				
				if (comm == "Order games") {
					System.out.println("Games");
					initOrderGames();
				}
				
				if (comm == "Checkout") {
					System.out.println("Checkout");
					initOrder();
				}

			}
		};
	}
	
	private void initMenuBar() {
		
		initMenuListener();
		
		JMenu menu = new JMenu("Drinks");
		menu.setMnemonic(KeyEvent.VK_D);
		menuBar.add(menu);
		
		//createMenuItem(menu, "Manage drinks", KeyEvent.VK_M, "Manage drinks");
		createMenuItem(menu, "Order drinks", KeyEvent.VK_O, "Order drinks");
		
		menu = new JMenu("Games");
		menu.setMnemonic(KeyEvent.VK_G);
		menuBar.add(menu);
		
		//createMenuItem(menu, "Manage games", KeyEvent.VK_M, "Manage games");
		createMenuItem(menu, "Order games", KeyEvent.VK_O, "Order games");
		
//		menu = new JMenu("Checkout");
//		menu.setMnemonic(KeyEvent.VK_G);
//		menuBar.add(menu);
//		
//		createMenuItem(menu, "Order", KeyEvent.VK_C, "Order");
//		//createMenuItem(menu, "Get XML", KeyEvent.VK_X, "Get XML");
//		
		
	}
		
	private void  initOrderProduct() {
		
		contentPane.removeAll();
		buttonPane.removeAll();
		table = TableLoader.getProductsTable();
		tablePane.setViewportView(table);
		JLabel quantityLabel = new JLabel("Quantity: ");
		quantity = new JTextField(2);
		
		JButton selectCustomer = new JButton("Select Customer");
		selectCustomer.addActionListener(new ActionListener() {
			
			@Override
			public void actionPerformed(ActionEvent arg0) {
				addCustomerSelector();
				addCustomerLabel();
			}
		});
		
		JButton toCart = new JButton("Add to Cart");
		toCart.addActionListener(new ActionListener() {
			
			@Override
			public void actionPerformed(ActionEvent arg0) {
				
				addTest();
				initOrderProduct();
				
				
				//System.out.println(id);
				
			}
		});
		buttonPane.add(customerLabel);
		buttonPane.add(quantityLabel);
		buttonPane.add(quantity);
		buttonPane.add(toCart);
		buttonPane.add(selectCustomer);
		
		contentPane.add(tablePane, BorderLayout.CENTER);
		contentPane.add(buttonPane, BorderLayout.NORTH);
		this.setVisible(true);
	}
	
	private void initOrderGames() {
		
		contentPane.removeAll();
		buttonPane.removeAll();
		
		table = TableLoader.getAvailableGameTable();
		tablePane.setViewportView(table);
		
		JButton toCart = new JButton("Add to Cart");
		toCart.addActionListener(new ActionListener() {
			
			@Override
			public void actionPerformed(ActionEvent arg0) {
				int row = table.getSelectedRow();
				int id = (int) table.getValueAt(row, 0);
				System.out.println(id);
				//gameCart.add(id);
				GameOrder go = new GameOrder(tableNumber, id);
				bd.insert(go);
				
			}
		});
		
		buttonPane.setVisible(true);
		
		
		contentPane.add(tablePane, BorderLayout.CENTER);
		contentPane.add(buttonPane, BorderLayout.NORTH);
		buttonPane.add(toCart);
		this.setVisible(true);
		
	}
	
	private void initOrder() {
		contentPane.removeAll();
		buttonPane.removeAll();
		
		table = TableLoader.getReceipt(productCart, gameCart);
		tablePane.setViewportView(table);
		
		JButton orderButton = new JButton("Place order");
		orderButton.addActionListener(new ActionListener() {
			
			@Override
			public void actionPerformed(ActionEvent arg0) {
				
				
			}
		});
		
		buttonPane.setVisible(true);
		
		DAOFactory df = DAOFactory.getInstance();
		BaseDAO bd = df.getBaseDAO();
		
		contentPane.add(tablePane, BorderLayout.CENTER);
		contentPane.add(buttonPane, BorderLayout.NORTH);
		buttonPane.add(orderButton);
		this.setVisible(true);
	}
	
	public void setTable(int i) {
		tableNumber = i;
	}
	
	private void addCustomerSelector() {
		new CustomerSelector(this);
	}
	
	private void addMessageSucces() {
		JOptionPane.showMessageDialog(this, "Order sent!");
	}
	
	private void addMessageFail() {
		JOptionPane.showMessageDialog(this, "Order could not be made!","Order could not be Made", JOptionPane.WARNING_MESSAGE);

	}
	
	public void addCustomerLabel() {
		buttonPane.remove(customerLabel);
		customerLabel.setText("Current customer: " + currentCustomer.getCustomerName());
		buttonPane.add(customerLabel, 0);
		initOrderProduct();
		setVisible(true);
	}

	@Override
	protected void updateCustomer() {
		
		initOrderProduct();
		addCustomerLabel();
		
	}
	
	protected void confirmOrder() throws UnsafeException {
		int row = table.getSelectedRow();
		int id = (int) table.getValueAt(row, 0);
		int q = Integer.parseInt(quantity.getText());
		Order order = new Order(q,
				id, 
				tableNumber, 
				currentCustomer.getCustomerID());
		bd.insertSafe(order);
	}
	
	private void addTest() {
		new TestGui(this);
	}
	
}
