package edu.ubb.scp.logic;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;

public class Password {
	private static byte[] bytes = new byte[64];
	static {
		init();
	}
	
	private static void init() {
		try {
			FileInputStream in = new FileInputStream("password");
			in.read(bytes, 0, 64);
			in.close();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
	
	/**
	 * Validates password
	 * @param password
	 * @return true if the password is valid
	 */
	public static boolean valid(String password) {
		return Arrays.equals(bytes, Hash.hashString(password));
	}
	
	/**
	 * Sets global password
	 * @param password
	 */
	public static void set(String password) {
		try {
			FileOutputStream out = new FileOutputStream("password");
			out.write(Hash.hashString(password));
			out.close();
			init();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
}
