package edu.ubb.scp.logic;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;

import edu.ubb.scp.dao.BaseDAO;
import edu.ubb.scp.dao.DAOFactory;
import edu.ubb.scp.model.Model;
import edu.ubb.scp.model.Product;
import edu.ubb.scp.model.ProductBrand;
import edu.ubb.scp.model.ProductType;
import edu.ubb.scp.model.Provider;

public class XML {
	private static int ind = 0;
	private static StringBuilder xml;
	private static BaseDAO dao = DAOFactory.getInstance().getBaseDAO();
	
	private static void append(String s) {
		for (int i = 0; i < ind; ++i)
			xml.append("\t");
		xml.append(s);
		xml.append("\n");
	}
	
	private static void push() {
		++ind;
	}
	
	private static void pop() {
		--ind;
	}
	
	private static void buildProviders() {
		ArrayList<Model> pr = dao.select(Provider.class);
		for (Model m : pr) {
			Provider p = (Provider) m;
			append("<provider id=\"p" + p.getProviderID() + "\">");
			push();
			append("<name>" + p.getProviderName() + "</name>");
			append("<address>" + p.getProviderAddress() + "</address>");
			append("<tel>" + p.getProviderTel() + "</tel>");
			pop();
			append("</provider>");
		}
	}
	
	private static void buildProductTypes() {
		ArrayList<Model> pr = dao.select(ProductType.class);
		for (Model m : pr) {
			ProductType p = (ProductType) m;
			append("<type id=\"t" + p.getProductTypeID() + "\">");
			push();
			append("<name>" + p.getProductTypeName() + "</name>");
			pop();
			append("</type>");
		}
	}
	
	private static void buildBrands() {
		ArrayList<Model> pr = dao.select(ProductBrand.class);
		for (Model m : pr) {
			ProductBrand p = (ProductBrand) m;
			append("<brand>");
			push();
			append("<name>" + p.getProductBrandName() + "</name>");
			append("<products>");
			push();
			buildProducts(p);
			pop();
			append("</products>");
			pop();
			append("</brand>");
		}
	}
	
	private static void buildProducts(ProductBrand brand) {
		ArrayList<Model> pr = dao.select(Product.class, "`ProductBrandID` = " + brand.getProductBrandID());
		for (Model m : pr) {
			Product p = (Product) m;
			append("<product type=\"t" + p.getProductTypeID() + "\" provider=\"p" + p.getProviderID() + "\">");
			push();
			append("<name>" + p.getProductName() + "</name>");
			append("<price>" + p.getPrice()+ "</price>");
			append("<stock>" + p.getStock() + "</stock>");
			pop();
			append("</product>");
		}
	}

	public static synchronized void exportProducts(String filename) {
		ind = 0;
		try {
			FileWriter out = new FileWriter(filename);
			BufferedReader dtd = new BufferedReader(new FileReader("pub.dtd"));
			xml = new StringBuilder();
			append("<?xml version=\"1.0\" encoding=\"" + System.getProperties().getProperty("file.encoding") + "\"?>");
			String line;
			while ((line = dtd.readLine()) != null) {
				xml.append(line + "\n");
			}
			append("<pub>");
			push();
			append("<providers>");
			push();
			buildProviders();
			pop();
			append("</providers>");
			append("<types>");
			push();
			buildProductTypes();
			pop();
			append("</types>");
			append("<brands>");
			push();
			buildBrands();
			pop();
			append("</brands>");
			pop();
			append("</pub>");
			out.write(xml.toString());
			out.close();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
}
