package edu.ubb.scp.model;

import java.lang.reflect.Field;

public class Product implements Model {
	private int ProductID;
	private String ProductName;
	private int Stock;
	private int ProviderID;
	private int ProductTypeID;
	private int ProductBrandID;
	private float Price;

	public Product(String productName, int stock, int providerID,
			int productTypeID, int productBrandID, float price) {
		super();
		ProductName = productName;
		Stock = stock;
		ProviderID = providerID;
		ProductTypeID = productTypeID;
		ProductBrandID = productBrandID;
		Price = price;
	}

	public Product() {

	}

	public int getProductID() {
		return ProductID;
	}

	public void setProductID(int productID) {
		ProductID = productID;
	}

	public String getProductName() {
		return ProductName;
	}

	public void setProductName(String productName) {
		ProductName = productName;
	}

	public int getStock() {
		return Stock;
	}

	public void setStock(int stock) {
		Stock = stock;
	}

	public int getProviderID() {
		return ProviderID;
	}

	public void setProviderID(int providerID) {
		ProviderID = providerID;
	}

	public int getProductTypeID() {
		return ProductTypeID;
	}

	public void setProductTypeID(int productTypeID) {
		ProductTypeID = productTypeID;
	}

	public int getProductBrandID() {
		return ProductBrandID;
	}

	public void setProductBrandID(int productBrandID) {
		ProductBrandID = productBrandID;
	}

	public float getPrice() {
		return Price;
	}

	public void setPrice(float price) {
		Price = price;
	}

	@Override
	public String toString() {
		return "Product [ProductID=" + ProductID + ", ProductName="
				+ ProductName + ", Stock=" + Stock + ", ProviderID="
				+ ProviderID + ", ProductTypeID=" + ProductTypeID
				+ ", ProductBrandID=" + ProductBrandID + ", Price=" + Price
				+ "]";
	}

	@Override
	public Field getPrimaryKey() {
		try {
			return Product.class.getDeclaredField("ProductID");
		} catch (NoSuchFieldException e) {
			e.printStackTrace();
		} catch (SecurityException e) {
			e.printStackTrace();
		}
		return null;
	}

	@Override
	public Field[] getKeys() {
		return new Field[] { getPrimaryKey() };
	}

}
