package edu.ubb.scp.test;

import java.util.ArrayList;

import edu.ubb.scp.dao.BaseDAO;
import edu.ubb.scp.dao.DAOFactory;
import edu.ubb.scp.model.*;

public class FillDB {
	public static void main(String[] args) {
		DAOFactory df = DAOFactory.getInstance();
		BaseDAO bd = df.getBaseDAO();

		/**
		 * Balazs
		 */
		Table[] ta = new Table[] {
				new Table(), new Table(), new Table(), new Table(), new Table(),
				new Table(), new Table(), new Table(), new Table(), new Table()
		};
		for (Table input : ta)
			bd.insert(input);
		
		
		ProductType[] pt = new ProductType[] {
				new ProductType("beer"),
				new ProductType("wine"),
				new ProductType("coffee"),
				new ProductType("soda"),
				new ProductType("snack")
		};
		for (ProductType input : pt)
			bd.insert(input);
		
		ProductBrand[] pb = new ProductBrand[] {
				new ProductBrand("Heineken"),
				new ProductBrand("Julius Mein"),
				new ProductBrand("Ciuc"),
				new ProductBrand("Pepsi"),
				new ProductBrand("Lays"),
				new ProductBrand("Egri borpinceszet")
		};
		for (ProductBrand input : pb)
			bd.insert(input);
		
		Provider[] pr = new Provider[] {
				new Provider("Balazs trans srl", "str bla nr 13", "0123456789"),
				new Provider("Sandor trans srl", "str bla nr 14", "1123456789"),
				new Provider("Szecsi trans srl", "str bla nr 15", "0223456789")
		};
		for (Provider input : pr)
			bd.insert(input);
		
		Product[] p = new Product[] {
				new Product("Heineken 0,5l", 20, pr[1].getProviderID(), pt[0].getProductTypeID(), pb[0].getProductBrandID(), 5f),
				new Product("Heineken 0,33l", 20, pr[1].getProviderID(), pt[0].getProductTypeID(), pb[0].getProductBrandID(), 4f),
				new Product("Ciuc 0,5l", 100, pr[1].getProviderID(), pt[0].getProductTypeID(), pb[2].getProductBrandID(), 4.2f),
				new Product("Egri bikaver", 10, pr[0].getProviderID(), pt[1].getProductTypeID(), pb[5].getProductBrandID(), 10f),
				new Product("Irish coffee", 20, pr[2].getProviderID(), pt[2].getProductTypeID(), pb[1].getProductBrandID(), 5f),
				new Product("Italian capuccino", 25, pr[2].getProviderID(), pt[2].getProductTypeID(), pb[1].getProductBrandID(), 5f),
				new Product("Pepsi twist", 120, pr[1].getProviderID(), pt[3].getProductTypeID(), pb[3].getProductBrandID(), 3.9f),
				new Product("Mirinda", 80, pr[1].getProviderID(), pt[3].getProductTypeID(), pb[3].getProductBrandID(), 3.9f),
				new Product("Lays salt", 50, pr[0].getProviderID(), pt[4].getProductTypeID(), pb[4].getProductBrandID(), 2.9f),
				new Product("Lays barbecue", 20, pr[0].getProviderID(), pt[4].getProductTypeID(), pb[4].getProductBrandID(), 2.9f)
		};
		for (Product input : p)
			bd.insert(input);

		Test[] te = new Test[] {
				new Test("two fingers test", "how many fingers am I holding up? ,,||_", "3"),
				new Test("beauty perception test", "what percentage of women here do you find attractive?", "30%"),
				new Test("puke test", "have you puked tonight?", "no sir")
		};
		for (Test input : te)
			bd.insert(input);
		
		Customer[] cu = new Customer[] {
				new Customer("Balazs", 20f),
				new Customer("Sandor", 10f),
				new Customer("Szecsi", 0f),
				new Customer("Katika", 0f),
				new Customer("Bandi", 30f)
		};
		for (Customer input : cu)
			bd.insert(input);
		
		CustomerTest[] ct = new CustomerTest[] {
				new CustomerTest(cu[0].getCustomerID(), te[0].getTestID(), "really drunk"),
				new CustomerTest(cu[1].getCustomerID(), te[2].getTestID(), "somewhat drunk"),
				new CustomerTest(cu[2].getCustomerID(), te[1].getTestID(), "too drunk to drive"),
				new CustomerTest(cu[3].getCustomerID(), te[2].getTestID(), "sober"),
				new CustomerTest(cu[4].getCustomerID(), te[0].getTestID(), "probably high")
		};
		for (CustomerTest input : ct)
			bd.insert(input);
		
		Order[] or = new Order[] {
				new Order(10, p[1].getProductID(), ta[0].getTableID(), cu[0].getCustomerID()),
				new Order(3, p[3].getProductID(), ta[0].getTableID(), cu[0].getCustomerID()),
				new Order(2, p[6].getProductID(), ta[0].getTableID(), cu[0].getCustomerID()),
				new Order(5, p[0].getProductID(), ta[0].getTableID(), cu[1].getCustomerID()),
				new Order(3, p[1].getProductID(), ta[0].getTableID(), cu[2].getCustomerID()),
				new Order(2, p[5].getProductID(), ta[3].getTableID(), cu[3].getCustomerID()),
				new Order(10, p[9].getProductID(), ta[3].getTableID(), cu[4].getCustomerID())
		};
		for (Order input : or)
			bd.insert(input);
		
		/**
		 * Sandor
		 */
		
		ArrayList<Game> games = new ArrayList<Game>();

		GameType[] gt = new GameType[] {
				new GameType("Card Game"),
				new GameType("Board Game"),
				new GameType("Party Game"),
				new GameType("Drinking Game"),
				new GameType("Puzzle Game")
		};
		for (GameType g : gt) {
			bd.insert(g);
		}

		GameBrand[] gb = new GameBrand[] {
				new GameBrand("Fantasy Flight Games"),
				new GameBrand("Wizards of the Coast"),
				new GameBrand("Rio Grande Games"),
				new GameBrand("Rubik"),
				new GameBrand("Walfrog Games")
		};
		
		for (GameBrand g : gb) {
			bd.insert(g);
		}

		int t = gt[0].getGameTypeID();
		int b = gb[0].getGameBrandID();

		games.add(new Game("Race for the galaxy", t, b));
		games.add(new Game("Game of Thrones Card Game", t, b));
		games.add(new Game("Galactic Civilizations", t, b));
		games.add(new Game("Citadels", t, b));


		t = gt[1].getGameTypeID();
		b = gb[0].getGameBrandID();

		games.add(new Game("Battlestar Galactica", t, b));
		games.add(new Game("Brittania", t, b));
		games.add(new Game("Blue Moon", t, b));
		games.add(new Game("Age of Connan", t, b));

		t = gt[1].getGameTypeID();
		b = gb[1].getGameBrandID();

		games.add(new Game("Magic The Gathering", t, b));
		games.add(new Game("Duel Masters", t, b));
		games.add(new Game("D&D the Card Game", t, b));

		t = gt[2].getGameTypeID();
		b = gb[2].getGameBrandID();

		games.add(new Game("Twister", t, b));
		games.add(new Game("Uno", t, b));
		games.add(new Game("Spin the bottle", t, b));

		t = gt[3].getGameTypeID();
		b = gb[4].getGameBrandID();

		games.add(new Game("Bolti", t, b));
		games.add(new Game("Integer Wars", t, b));
		games.add(new Game("Beer Pong", t, b));

		t = gt[4].getGameTypeID();
		b = gb[3].getGameBrandID();

		games.add(new Game("Rubic cube 2x2", t, b));
		games.add(new Game("Rubic cube 3x3", t, b));
		games.add(new Game("Rubic cube 4x4", t, b));

		for (Game g : games) {
			bd.insert(g);
		}

		GameOrder[] orders = new GameOrder[] { 
				new GameOrder(ta[0].getTableID(), games.get(0).getGameID()),
				new GameOrder(ta[0].getTableID(), games.get(2).getGameID()),
				new GameOrder(ta[3].getTableID(), games.get(7).getGameID()),
				new GameOrder(ta[0].getTableID(), games.get(8).getGameID()),
		};
		for (GameOrder order : orders) {
			bd.insert(order);
		}
	}
}
