/**
 *  Serponix is an arcade game in focus to multiplayer based on the classic game Snake.
 *  Copyright (C) 2010 - 2011  Daniel Vala
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License,
 *  or  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *  If you have any question do not hesitate to contact author
 *  on e-mail address: danielvala42@gmail.com
 */
package com.serponix.abilities;

import com.serponix.game.ModelFun;
import com.serponix.game.Snake;

/**
 * Vlastnost duch umožní hadovi projít skrz všechny zdi, střely a hady.
 * Stále však může nabourat do okraje herní plochy.
 * Vlastnost není kompatibilní s vlastností tank.
 *
 * @author Daniel Vala
 */
public class Duch extends Ability {

	/**
	 * Vytvoří vlastnost duch s danou vzácností.
	 *
	 * @param sance Určuje, jak často se bude vlastnost generovat.
	 */
	public Duch(int sance) {
		super(sance);
	}

	/**
	 * Z hada se stane duch. Bude moci procházet zdmi, střelami a hady.
	 * Pokud had již vlastní tank, nemůže získat vlastnost duch.
	 *
	 * @param model Model hry.
	 * @param had   Had, který se stane duchem.
	 * @return True, pokud had vlastnost získal. Jinak false.
	 */
	@Override
	public boolean proved(ModelFun model, Snake had) {
		if (had.isVlastnostTank()) {
			return false;
		}
		if (had.isVlastnostDuch()) {
			model.getPanelZprav().addMessage(String.format("%s bude duchem déle!", had));
		} else {
			model.getPanelZprav().addMessage(String.format("%s se stal duchem.", had));
		}
		had.setVlastnostDuch(true);
		return true;
	}
}
