/**
 *  Serponix is an arcade game in focus to multiplayer based on the classic game Snake.
 *  Copyright (C) 2010 - 2011  Daniel Vala
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License,
 *  or  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *  If you have any question do not hesitate to contact author
 *  on e-mail address: danielvala42@gmail.com
 */
package com.serponix.abilities;

import com.serponix.game.ModelFun;
import com.serponix.game.Snake;

/**
 * Vlastnost elixír života vzkřísí náhodného hada, který je již mrtev.
 *
 * @author Daniel Vala
 */
public class ElixirZivota extends Ability {

	/**
	 * Vytvoří vlastnost elixír života s danou vzácností.
	 *
	 * @param sance Určuje, jak často se bude vlastnost generovat.
	 */
	public ElixirZivota(int sance) {
		super(sance);
	}

	/**
	 * Pokud je alespoň jeden had ve hře mrtev, s velkou pravděpodobností jej oživí.
	 * Pokud je mrtvých hadů více, využije náhody.
	 *
	 * @param model Model hry.
	 * @param had   Had, který oživuje jiného hada.
	 * @return True, pokud byl nějáký had oživen.
	 */
	@Override
	public boolean proved(ModelFun model, Snake had) {
		return model.ozivNahodnehoHada(had);
	}
}
