/**
 *  Serponix is an arcade game in focus to multiplayer based on the classic game Snake.
 *  Copyright (C) 2010 - 2011  Daniel Vala
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License,
 *  or  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *  If you have any question do not hesitate to contact author
 *  on e-mail address: danielvala42@gmail.com
 */
package com.serponix.abilities;

import com.serponix.game.ModelFun;
import com.serponix.game.Snake;

/**
 * Vlastnost steak zdvojnásobí hada.
 *
 * @author Daniel Vala
 */
public class Steak extends Ability {

	/**
	 * Vytvoří vlastnost steak s danou vzácností.
	 *
	 * @param sance Určuje, jak často se bude vlastnost generovat.
	 */
	public Steak(int sance) {
		super(sance);
	}

	/**
	 * Had se zdvojnásobí, pokud by poté nebyl natolik velký, že by zvítězil.
	 *
	 * @param model Model hry.
	 * @param had   Had, který se zdvojnásobí.
	 * @return True, pokud se had zdvojnásobil. Jinak false.
	 */
	@Override
	public boolean proved(ModelFun model, Snake had) {
		if (had.getVelikostProVitezstvi() / 2 > had.getDelka()) {
			had.zdvojnasobSe();
			model.getPanelZprav().addMessage(String.format("%s sežral steak a zdvojnásobil se.", had));
			return true;
		} else {
			return false;
		}
	}
}
