/**
 *  Serponix is an arcade game in focus to multiplayer based on the classic game Snake.
 *  Copyright (C) 2010 - 2011  Daniel Vala
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License,
 *  or  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *  If you have any question do not hesitate to contact author
 *  on e-mail address: danielvala42@gmail.com
 */
package com.serponix.abilities;

import com.serponix.game.ModelFun;
import com.serponix.game.Snake;

/**
 * Vlastnost štít dá hadovi odolnost proti všem laserům.
 * Pokud hada zasáhne laser, střela se pouze odrazí.
 * Štít hada neuchrání před zásahem do hlavy a zásahem rakety.
 * Vlastnost není kompatibilní s vlastností duch.
 *
 * @author Daniel Vala
 */
public class Stit extends Ability {

	/**
	 * Vytvoří vlastnost raketa s danou vzácností.
	 *
	 * @param sance Určuje, jak často se bude vlastnost generovat.
	 */
	public Stit(int sance) {
		super(sance);
	}

	/**
	 * Had získá štit.
	 * Pokud je had duchem, štít nezíská, protože by neměl žádný smysl.
	 *
	 * @param model Model hry.
	 * @param had   Had, který získá štít.
	 * @return True, pokud had získal štít. Jinak false.
	 */
	@Override
	public boolean proved(ModelFun model, Snake had) {
		if (had.isVlastnostDuch()) {
			return false;
		}
		if (had.isVlastnostOdolny()) {
			model.getPanelZprav().addMessage(String.format("%s sebral další štít a bude déle odolný!", had));
		} else {
			model.getPanelZprav().addMessage(String.format("%s sebral štít a získal tak odolnost", had));
		}
		had.setVlastnostIlvulnerability(true);
		return true;
	}
}
